/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch;

import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitHubBranchBuildStrategy
extends BranchBuildStrategy {
    @DataBoundConstructor
    public GitHubBranchBuildStrategy() {
    }

    public boolean isAutomaticBuild(SCMSource source, SCMHead head) {
        return false;
    }

    public boolean isAutomaticBuild(SCMSource source, SCMHead head, SCMRevision revision) {
        if (!(revision instanceof GitHubSCMRevision)) {
            return false;
        }
        GitHubSCMRevision gr = (GitHubSCMRevision)revision;
        if (gr.getCause() == null) {
            return false;
        }
        return !gr.getCause().isSkip();
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, SCMRevision lastBuiltRevision, SCMRevision lastSeenRevision, @NonNull TaskListener listener) {
        return this.isAutomaticBuild(source, head, currRevision);
    }

    @Symbol(value={"gitHubEvents"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        public boolean isApplicable(SCMSourceDescriptor sourceDescriptor) {
            return sourceDescriptor.clazz == GitHubSCMSource.class;
        }

        @NonNull
        public String getDisplayName() {
            return "GitHub events based branch build strategy";
        }
    }
}

