/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.multibranch;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubBranchHandler;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.util.function.Predicate;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;

public class Functions {
    private Functions() {
    }

    public static <ITEM extends Item> Predicate<ITEM> withTrigger(Class<? extends Trigger> clazz) {
        return item -> JobInfoHelpers.triggerFrom((Item)item, (Class)clazz) != null;
    }

    public static <ITEM extends Item> Predicate<ITEM> isBuildable() {
        return item -> {
            if (item instanceof Job) {
                return ((Job)item).isBuildable();
            }
            if (item instanceof ComputedFolder) {
                return ((ComputedFolder)item).isBuildable();
            }
            return item instanceof BuildableItem;
        };
    }

    public static <ITEM extends Item> Predicate<ITEM> withBranchHandler() {
        return item -> {
            if (item instanceof SCMSourceOwner) {
                SCMSourceOwner scmSourceOwner = (SCMSourceOwner)item;
                for (SCMSource source : scmSourceOwner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    GitHubSCMSource gitHubSCMSource = (GitHubSCMSource)source;
                    for (GitHubHandler hubHandler : gitHubSCMSource.getHandlers()) {
                        if (!(hubHandler instanceof GitHubBranchHandler)) continue;
                        return true;
                    }
                }
            }
            return false;
        };
    }

    public static <PROJECT extends MultiBranchProject> Predicate<PROJECT> withGitHubSCMSource() {
        return project -> project.getSCMSources().stream().anyMatch(p -> p instanceof GitHubSCMSource);
    }
}

