/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic.utils;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableGitHubOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableGitHubOperation.class);

    private RetryableGitHubOperation() {
    }

    public static <T> T execute(GitOperation<T> operation) throws IOException {
        return RetryableGitHubOperation.execute(3, 2000L, operation);
    }

    public static <T> T execute(int retries, long delay, GitOperation<T> operation) throws IOException {
        T result = null;
        int count = 0;
        while (count++ < retries) {
            try {
                result = operation.execute();
                break;
            }
            catch (IOException e) {
                if (count == retries) {
                    throw e;
                }
                LOG.debug("Failed retrieving pull request(s), retrying...", (Throwable)e);
                RetryableGitHubOperation.sleep(delay);
            }
        }
        return result;
    }

    private static void sleep(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while delaying git operation", (Throwable)e);
        }
    }

    public static interface GitOperation<T> {
        public T execute() throws IOException;
    }
}

