/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic.errors;

import com.github.kostyasha.github.integration.generic.errors.GitHubError;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ProminentProjectAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GitHubErrorsAction
implements ProminentProjectAction {
    private String description;
    private final Set<GitHubError> errors = Collections.synchronizedSet(new HashSet());

    public GitHubErrorsAction(@NonNull String description) {
        this.description = description;
    }

    public boolean hasVisibleErrors() {
        boolean hasVisible = false;
        for (GitHubError error : this.errors) {
            if (!error.isVisible()) continue;
            hasVisible = true;
            break;
        }
        return hasVisible;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Set<GitHubError> getErrors() {
        return this.errors;
    }

    public boolean addOrReplaceError(@NonNull GitHubError a) {
        if (Objects.isNull(a)) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        HashSet<GitHubError> old = new HashSet<GitHubError>(1);
        Set<GitHubError> current = this.getErrors();
        boolean found = false;
        for (GitHubError curErr : current) {
            if (!found && a.equals(curErr)) {
                found = true;
                continue;
            }
            if (curErr.getClass() != a.getClass()) continue;
            old.add(curErr);
        }
        current.removeAll(old);
        if (!found) {
            this.getErrors().add(a);
        }
        return !found || !old.isEmpty();
    }

    public boolean removeErrors(@NonNull Class<? extends GitHubError> clazz) {
        if (Objects.isNull(clazz)) {
            throw new IllegalArgumentException("Action type must be non-null");
        }
        HashSet<GitHubError> old = new HashSet<GitHubError>();
        Set<GitHubError> current = this.getErrors();
        for (GitHubError err : current) {
            if (!clazz.isInstance(err)) continue;
            old.add(err);
        }
        return current.removeAll(old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<GitHubError> getErrorsSnapshot() {
        Set<GitHubError> set = this.errors;
        synchronized (set) {
            return new HashSet<GitHubError>(this.getErrors());
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "";
    }

    public String getUrlName() {
        return "";
    }
}

