/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Optional;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.TriggerDescriptor;
import hudson.util.SequentialExecutionQueue;
import java.net.URI;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.StaplerRequest;

public abstract class GitHubTriggerDescriptor
extends TriggerDescriptor {
    private transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Jenkins.MasterComputer.threadPoolForRemoting);
    private String publishedURL;
    private boolean actualiseOnFactory = false;

    @NonNull
    public SequentialExecutionQueue getQueue() {
        if (Objects.isNull(this.queue)) {
            this.queue = new SequentialExecutionQueue(Jenkins.MasterComputer.threadPoolForRemoting);
        }
        return this.queue;
    }

    public String getPublishedURL() {
        return this.publishedURL;
    }

    public void setPublishedURL(String publishedURL) {
        this.publishedURL = publishedURL;
    }

    public boolean isActualiseOnFactory() {
        return this.actualiseOnFactory;
    }

    public void setActualiseOnFactory(boolean actualiseOnFactory) {
        this.actualiseOnFactory = actualiseOnFactory;
    }

    public String getJenkinsURL() {
        Object url = this.getPublishedURL();
        if (StringUtils.isNotBlank((String)url)) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            return url;
        }
        return GitHubWebHook.getJenkinsInstance().getRootUrl();
    }

    @NonNull
    public static GitHub githubFor(URI uri) {
        Optional client = FluentIterableWrapper.from((Iterable)GitHubPlugin.configuration().findGithubConfig(GitHubServerConfig.withHost((String)uri.getHost()))).first();
        if (client.isPresent()) {
            return (GitHub)client.get();
        }
        throw new GHPluginConfigException("Can't find appropriate client for github repo <%s>", new Object[]{uri});
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        return super.configure(req, formData);
    }

    public boolean isApplicable(Item item) {
        return item instanceof Job && Objects.nonNull(SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item)) && item instanceof ParameterizedJobMixIn.ParameterizedJob;
    }
}

