/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import antlr.ANTLRException;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.github.kostyasha.github.integration.generic.GitHubPollingLogAction;
import com.github.kostyasha.github.integration.generic.GitHubRepoProvider;
import com.github.kostyasha.github.integration.generic.errors.GitHubErrorsAction;
import com.github.kostyasha.github.integration.generic.errors.impl.GitHubRepoProviderError;
import com.github.kostyasha.github.integration.generic.repoprovider.GitHubPluginRepoProvider;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitHubTrigger<T extends GitHubTrigger<T>>
extends Trigger<Job<?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubTrigger.class);
    @CheckForNull
    private GitHubPRTriggerMode triggerMode = GitHubPRTriggerMode.CRON;
    protected boolean cancelQueued = false;
    private boolean abortRunning = false;
    protected boolean skipFirstRun = false;
    @Beta
    private List<GitHubRepoProvider> repoProviders = InvokerHelper.asList((Object)((Object)new GitHubPluginRepoProvider()));
    private transient GitHubRepoProvider repoProvider = null;
    @CheckForNull
    private GitHubErrorsAction errorsAction;
    private transient GitHubRepositoryName repoName;

    protected GitHubTrigger(String cronTabSpec) throws ANTLRException {
        super(cronTabSpec);
    }

    public GitHubTrigger(String spec, GitHubPRTriggerMode triggerMode) throws ANTLRException {
        super(spec);
        this.triggerMode = triggerMode;
    }

    @NonNull
    public GitHubPRTriggerMode getTriggerMode() {
        return Objects.isNull((Object)this.triggerMode) ? GitHubPRTriggerMode.CRON : this.triggerMode;
    }

    public void setTriggerMode(GitHubPRTriggerMode triggerMode) {
        this.triggerMode = triggerMode;
    }

    public boolean isCancelQueued() {
        return this.cancelQueued;
    }

    @DataBoundSetter
    public void setCancelQueued(boolean cancelQueued) {
        this.cancelQueued = cancelQueued;
    }

    public boolean isAbortRunning() {
        return this.abortRunning;
    }

    @DataBoundSetter
    public void setAbortRunning(boolean abortRunning) {
        this.abortRunning = abortRunning;
    }

    public boolean isSkipFirstRun() {
        return this.skipFirstRun;
    }

    @DataBoundSetter
    public void setSkipFirstRun(boolean skipFirstRun) {
        this.skipFirstRun = skipFirstRun;
    }

    public GitHubRepositoryName getRepoName() {
        return this.repoName;
    }

    public void setRepoName(GitHubRepositoryName repoName) {
        this.repoName = repoName;
    }

    public void start(Job<?, ?> project, boolean newInstance) {
        this.repoName = null;
        this.getRepoProviders().forEach(GitHubRepoProvider::onTriggerStart);
        super.start(project, newInstance);
    }

    @Beta
    @NonNull
    public List<GitHubRepoProvider> getRepoProviders() {
        if (Objects.isNull(this.repoProviders)) {
            this.repoProviders = InvokerHelper.asList((Object)((Object)new GitHubPluginRepoProvider()));
        }
        return this.repoProviders;
    }

    @DataBoundSetter
    @Beta
    public void setRepoProviders(List<GitHubRepoProvider> repoProviders) {
        this.repoProviders = repoProviders;
    }

    @Beta
    public void setRepoProvider(@NonNull GitHubRepoProvider prov) {
        this.repoProviders = InvokerHelper.asList((Object)((Object)prov));
    }

    @Beta
    public GitHubRepoProvider getRepoProvider() {
        ArrayList<Exception> throwables = new ArrayList<Exception>();
        if (Objects.isNull((Object)this.repoProvider)) {
            boolean failed = false;
            for (GitHubRepoProvider prov : this.getRepoProviders()) {
                try {
                    prov.getGHRepository(this);
                    this.repoProvider = prov;
                }
                catch (Exception ex) {
                    LOG.debug("Provider failed:", (Throwable)ex);
                    throwables.add(ex);
                    failed = true;
                }
            }
            if (failed) {
                LOG.error("Can't find repo provider for GitHubBranchTrigger job: {}. All repo providers failed: {}", (Object)this.getJob().getFullName(), throwables);
            }
        }
        if (Objects.isNull((Object)this.repoProvider)) {
            this.getErrorsAction().addOrReplaceError(new GitHubRepoProviderError(String.format("Can't find repo provider for %s.<br/> All providers failed: %s", ((Job)this.job).getFullName(), throwables)));
        }
        Preconditions.checkState((boolean)Objects.nonNull((Object)this.repoProvider), (String)"Can't find repo provider for %s", (Object)((Job)this.job).getFullName());
        this.getErrorsAction().removeErrors(GitHubRepoProviderError.class);
        return this.repoProvider;
    }

    @NonNull
    public GHRepository getRemoteRepository() throws IOException {
        GHRepository remoteRepository = this.getRepoProvider().getGHRepository(this);
        Preconditions.checkState((boolean)Objects.nonNull(remoteRepository), (String)"Can't get remote GH repo for %s", (Object)((Job)this.job).getFullName());
        return remoteRepository;
    }

    @NonNull
    public GitHubErrorsAction getErrorsAction() {
        if (Objects.isNull(this.errorsAction)) {
            this.errorsAction = new GitHubErrorsAction(this.getDescriptor().getDisplayName() + " Trigger Errors");
        }
        return this.errorsAction;
    }

    public void stop() {
        this.repoName = null;
        this.getRepoProviders().forEach(GitHubRepoProvider::onTriggerStop);
        if (Objects.nonNull(this.job)) {
            LOG.info("Stopping '{}' for project '{}'", (Object)this.getDescriptor().getDisplayName(), (Object)((Job)this.job).getFullName());
        }
        super.stop();
    }

    public abstract String getFinishMsg();

    public abstract GitHubPollingLogAction getPollingLogAction();

    public abstract void doRun();

    @NonNull
    public Collection<? extends Action> getProjectActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (Objects.nonNull(this.getPollingLogAction())) {
            actions.add(this.getPollingLogAction());
        }
        actions.add(this.getErrorsAction());
        return actions;
    }

    @CheckForNull
    public Job getJob() {
        return (Job)this.job;
    }

    public GitHubRepositoryName getRepoFullName() {
        return this.getRepoFullName(this.getJob());
    }

    public GitHubRepositoryName getRepoFullName(Job item) {
        Job job = item;
        if (Objects.isNull(this.repoName)) {
            Preconditions.checkNotNull((Object)job, (Object)"job object is null, race condition?");
            GithubProjectProperty ghpp = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
            Preconditions.checkNotNull((Object)ghpp, (String)"GitHub project property is not defined. Can't setup GitHub trigger for job %s", (Object)job.getName());
            Preconditions.checkNotNull((Object)ghpp.getProjectUrl(), (Object)"A GitHub project url is required");
            GitHubRepositoryName repo = GitHubRepositoryName.create((String)ghpp.getProjectUrl().baseUrl());
            Preconditions.checkNotNull((Object)repo, (String)"Invalid GitHub project url: %s", (Object)ghpp.getProjectUrl().baseUrl());
            this.setRepoName(repo);
        }
        return this.repoName;
    }

    public void trySave() {
        try {
            ((Job)this.job).save();
        }
        catch (IOException e) {
            LOG.error("Error while saving job to file", (Throwable)e);
        }
    }

    protected void saveIfSkipFirstRun() {
        if (this.skipFirstRun) {
            LOG.info("Skipping first run for {}", (Object)((Job)this.job).getFullName());
            this.skipFirstRun = false;
            this.trySave();
        }
    }
}

