/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.github.kostyasha.github.integration.generic.GitHubDecisionContext;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubTagHandler;
import com.github.kostyasha.github.integration.tag.GitHubTag;
import com.github.kostyasha.github.integration.tag.GitHubTagCause;
import com.github.kostyasha.github.integration.tag.GitHubTagRepository;
import com.github.kostyasha.github.integration.tag.events.GitHubTagEvent;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import org.kohsuke.github.GHTag;

public class GitHubTagDecisionContext
extends GitHubDecisionContext<GitHubTagEvent, GitHubTagCause> {
    private final GHTag remoteTag;
    private final GitHubTag localTag;
    private final GitHubTagRepository localRepo;

    public GitHubTagDecisionContext(GHTag remoteTag, GitHubTag localTag, @NonNull GitHubTagRepository localRepo, GitHubTagHandler tagHandler, GitHubSCMSource scmSource, TaskListener listener) {
        super(listener, null, scmSource, tagHandler);
        this.remoteTag = remoteTag;
        this.localTag = localTag;
        this.localRepo = localRepo;
    }

    @CheckForNull
    public GHTag getRemoteTag() {
        return this.remoteTag;
    }

    @CheckForNull
    public GitHubTag getLocalTag() {
        return this.localTag;
    }

    @NonNull
    public GitHubTagRepository getLocalRepo() {
        return this.localRepo;
    }

    @Override
    public GitHubTagHandler getHandler() {
        return (GitHubTagHandler)super.getHandler();
    }

    @Override
    public GitHubTagCause checkEvent(GitHubTagEvent event) throws IOException {
        return event.check(this);
    }

    @Override
    public GitHubTagCause newCause(String reason, boolean skip) {
        if (this.remoteTag != null) {
            return new GitHubTagCause(this.remoteTag, this.localRepo, reason, skip);
        }
        return new GitHubTagCause(this.localTag, this.localRepo, reason, skip);
    }

    @NonNull
    public static Builder newGitHubTagDecisionContext() {
        return new Builder();
    }

    public static class Builder {
        private GHTag remoteTag = null;
        private GitHubTag localTag = null;
        private TaskListener listener;
        private GitHubTagHandler tagHandler = null;
        private GitHubSCMSource scmSource;
        private GitHubTagRepository localRepo;

        public Builder withRemoteTag(@CheckForNull GHTag remoteTag) {
            this.remoteTag = remoteTag;
            return this;
        }

        public Builder withLocalTag(@CheckForNull GitHubTag localTag) {
            this.localTag = localTag;
            return this;
        }

        public Builder withLocalRepo(GitHubTagRepository localRepo) {
            this.localRepo = localRepo;
            return this;
        }

        public Builder withListener(@NonNull TaskListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withTagHandler(@CheckForNull GitHubTagHandler tagHandler) {
            this.tagHandler = tagHandler;
            return this;
        }

        public Builder withSCMSource(GitHubSCMSource scmSource) {
            this.scmSource = scmSource;
            return this;
        }

        public GitHubTagDecisionContext build() {
            Objects.requireNonNull(this.tagHandler);
            Objects.requireNonNull(this.scmSource);
            Objects.requireNonNull(this.listener);
            return new GitHubTagDecisionContext(this.remoteTag, this.localTag, this.localRepo, this.tagHandler, this.scmSource, this.listener);
        }
    }
}

