/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Objects;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitHubRepository<T extends GitHubRepository>
implements Action,
Saveable {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubRepository.class);
    protected transient XmlFile configFile;
    protected transient Job<?, ?> job;
    protected transient boolean changed;
    @CheckForNull
    private String fullName;
    @CheckForNull
    private URL githubUrl;
    @CheckForNull
    private String gitUrl;
    @CheckForNull
    private String sshUrl;

    public GitHubRepository(@NonNull GHRepository ghRepository) throws IOException {
        this.actualise(ghRepository, TaskListener.NULL);
    }

    public GitHubRepository(String repoFullName, URL githubUrl) {
        this.fullName = repoFullName;
        this.githubUrl = githubUrl;
    }

    public synchronized void actualise(@NonNull GHRepository ghRepository, @NonNull TaskListener listener) throws IOException {
        this.changed = false;
        PrintStream logger = listener.getLogger();
        if (Objects.isNull(this.fullName) || !this.fullName.equalsIgnoreCase(ghRepository.getFullName())) {
            logger.printf("Repository full name changed from '%s' to '%s'.%n", this.fullName, ghRepository.getFullName());
            this.fullName = ghRepository.getFullName();
            this.changed = true;
        }
        if (Objects.isNull(this.githubUrl) || !this.githubUrl.toExternalForm().equalsIgnoreCase(ghRepository.getHtmlUrl().toExternalForm())) {
            logger.printf("Changing GitHub url from '%s' to '%s'.%n", this.githubUrl, ghRepository.getHtmlUrl());
            this.githubUrl = ghRepository.getHtmlUrl();
        }
        if (Objects.isNull(this.gitUrl) || !this.gitUrl.equalsIgnoreCase(ghRepository.getGitTransportUrl())) {
            logger.printf("Changing Git url from '%s' to '%s'.%n", this.gitUrl, ghRepository.getGitTransportUrl());
            this.gitUrl = ghRepository.getGitTransportUrl();
        }
        if (Objects.isNull(this.sshUrl) || !this.sshUrl.equalsIgnoreCase(ghRepository.getSshUrl())) {
            logger.printf("Changing SSH url from '%s' to '%s'.%n", this.sshUrl, ghRepository.getSshUrl());
            this.sshUrl = ghRepository.getSshUrl();
        }
        this.actualiseOnChange(ghRepository, listener);
    }

    protected abstract void actualiseOnChange(@NonNull GHRepository var1, @NonNull TaskListener var2);

    public String getFullName() {
        return this.fullName;
    }

    public GitHubRepository<T> withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public URL getGithubUrl() {
        return this.githubUrl;
    }

    public GitHubRepository<T> withGithubUrl(URL githubUrl) {
        this.githubUrl = githubUrl;
        return this;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public GitHubRepository<T> withGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public GitHubRepository<T> withSshUrl(String sshUrl) {
        this.sshUrl = sshUrl;
        return this;
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public void setJob(Job<?, ?> job) {
        this.job = job;
    }

    public XmlFile getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(XmlFile configFile) {
        this.configFile = configFile;
    }

    public void saveQuietly() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOG.error("Can't save repository state, because: '{}'", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        GitHubRepository gitHubRepository = this;
        synchronized (gitHubRepository) {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            this.configFile.write((Object)this);
        }
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.configFile);
    }

    public abstract FormValidation doClearRepo() throws IOException;

    public abstract FormValidation doRunTrigger() throws IOException;

    public abstract FormValidation doRebuildAllFailed() throws IOException;

    public abstract FormValidation doBuild(StaplerRequest var1) throws IOException;

    public abstract FormValidation doRebuild(StaplerRequest var1) throws IOException;
}

