/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixChildAction;
import hudson.matrix.MatrixRun;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FlushProofOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.RunAction2;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class GitHubPollingLogAction
implements MatrixChildAction,
RunAction2 {
    @CheckForNull
    private transient Job<?, ?> job;
    @CheckForNull
    private transient Run<?, ?> run;

    public GitHubPollingLogAction(Job<?, ?> job) {
        this.job = job;
    }

    public GitHubPollingLogAction(Run run) {
        this.run = run;
    }

    public abstract String getPollingFileName();

    @CheckForNull
    public Job<?, ?> getJob() {
        return this.job;
    }

    public void setJob(Job<?, ?> job) {
        this.job = job;
    }

    @CheckForNull
    public Run<?, ?> getRun() {
        return this.run;
    }

    public void setRun(Run<?, ?> run) {
        this.run = run;
    }

    public String getLog() throws IOException {
        return Util.loadFile((File)this.getPollingLogFile());
    }

    public boolean isLogExists() {
        return this.getPollingLogFile() != null && this.getPollingLogFile().isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPollingLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        FlushProofOutputStream out = new FlushProofOutputStream(rsp.getCompressedOutputStream((HttpServletRequest)req));
        try {
            this.getPollingLogText().writeLogTo(0L, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public AnnotatedLargeText getPollingLogText() {
        return new AnnotatedLargeText(this.getPollingLogFile(), Charset.defaultCharset(), true, (Object)this);
    }

    public void writePollingLogTo(XMLOutput out) throws IOException {
        new AnnotatedLargeText(this.getPollingLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
    }

    @NonNull
    public File getPollingLogFile() {
        File pollingFile;
        if (Objects.nonNull(this.job)) {
            pollingFile = this.job.getRootDir();
        } else if (this.run instanceof MatrixRun) {
            MatrixRun matrixRun = (MatrixRun)this.run;
            pollingFile = matrixRun.getParentBuild().getRootDir();
        } else if (this.run instanceof MatrixBuild) {
            pollingFile = this.run.getRootDir();
        } else if (Objects.nonNull(this.run)) {
            pollingFile = this.run.getRootDir();
        } else {
            throw new IllegalStateException("Can't get polling log file: no run or job initialised");
        }
        return new File(pollingFile, this.getPollingFileName());
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }
}

