/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.github.kostyasha.github.integration.generic.GitHubDecisionContext;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubPRHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRCause;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRPullRequest;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.jenkinsci.plugins.github.pullrequest.events.GitHubPREvent;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRUserRestriction;
import org.kohsuke.github.GHPullRequest;

public class GitHubPRDecisionContext
extends GitHubDecisionContext<GitHubPREvent, GitHubPRCause> {
    private final GHPullRequest remotePR;
    private final GitHubPRPullRequest localPR;
    private final GitHubPRUserRestriction prUserRestriction;
    private final GitHubPRRepository localRepo;

    protected GitHubPRDecisionContext(@CheckForNull GHPullRequest remotePR, @CheckForNull GitHubPRPullRequest localPR, @CheckForNull GitHubPRRepository localRepo, @CheckForNull GitHubPRUserRestriction prUserRestriction, GitHubSCMSource source, GitHubPRHandler prHandler, GitHubPRTrigger prTrigger, @NonNull TaskListener listener) {
        super(listener, prTrigger, source, prHandler);
        this.remotePR = remotePR;
        this.localPR = localPR;
        this.localRepo = localRepo;
        this.prUserRestriction = prUserRestriction;
    }

    @Deprecated
    protected GitHubPRDecisionContext(@CheckForNull GHPullRequest remotePR, @CheckForNull GitHubPRPullRequest localPR, @CheckForNull GitHubPRUserRestriction prUserRestriction, GitHubSCMSource source, GitHubPRHandler prHandler, GitHubPRTrigger prTrigger, @NonNull TaskListener listener) {
        this(remotePR, localPR, null, prUserRestriction, source, prHandler, prTrigger, listener);
    }

    @NonNull
    public GHPullRequest getRemotePR() {
        return this.remotePR;
    }

    @CheckForNull
    public GitHubPRPullRequest getLocalPR() {
        return this.localPR;
    }

    @CheckForNull
    public GitHubPRRepository getLocalRepo() {
        return this.localRepo;
    }

    @CheckForNull
    public GitHubPRUserRestriction getPrUserRestriction() {
        return this.prUserRestriction;
    }

    public GitHubPRTrigger getTrigger() {
        return (GitHubPRTrigger)super.getTrigger();
    }

    @Override
    public GitHubPRHandler getHandler() {
        return (GitHubPRHandler)super.getHandler();
    }

    @Deprecated
    @CheckForNull
    public GitHubPRTrigger getPrTrigger() {
        return this.getTrigger();
    }

    @Override
    public GitHubPRCause checkEvent(GitHubPREvent event) throws IOException {
        return event.check(this);
    }

    @Override
    public GitHubPRCause newCause(String reason, boolean skip) {
        if (this.remotePR != null) {
            return new GitHubPRCause(this.remotePR, this.localRepo, reason, skip);
        }
        return new GitHubPRCause(this.localPR, null, this.localRepo, skip, reason);
    }

    @NonNull
    public static Builder newGitHubPRDecisionContext() {
        return new Builder();
    }

    public static class Builder {
        private GHPullRequest remotePR = null;
        private GitHubPRPullRequest localPR = null;
        private GitHubPRRepository localRepo = null;
        private TaskListener listener;
        private GitHubPRUserRestriction prUserRestriction = null;
        private GitHubPRHandler prHandler = null;
        private GitHubPRTrigger prTrigger = null;
        private GitHubSCMSource source;

        public Builder withRemotePR(@CheckForNull GHPullRequest remotePR) {
            this.remotePR = remotePR;
            return this;
        }

        public Builder withLocalPR(@CheckForNull GitHubPRPullRequest localPR) {
            this.localPR = localPR;
            return this;
        }

        public Builder withLocalRepo(GitHubPRRepository localRepo) {
            this.localRepo = localRepo;
            return this;
        }

        public Builder withListener(@NonNull TaskListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withPrHandler(@CheckForNull GitHubPRHandler prHandler) {
            this.prHandler = prHandler;
            return this;
        }

        public Builder withSCMSource(GitHubSCMSource source) {
            this.source = source;
            return this;
        }

        public Builder withPrTrigger(GitHubPRTrigger prTrigger) {
            this.prTrigger = prTrigger;
            return this;
        }

        public GitHubPRDecisionContext build() {
            if (Objects.isNull((Object)this.prHandler)) {
                Objects.requireNonNull(this.prTrigger);
            } else {
                Objects.requireNonNull(this.prHandler);
                Objects.requireNonNull(this.source);
            }
            Objects.requireNonNull(this.listener);
            return new GitHubPRDecisionContext(this.remotePR, this.localPR, this.localRepo, this.prUserRestriction, this.source, this.prHandler, this.prTrigger, this.listener);
        }
    }
}

