/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubTrigger;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import org.kohsuke.github.GHRepository;

public abstract class GitHubDecisionContext<E, C extends GitHubCause<C>> {
    private final TaskListener listener;
    private final GitHubTrigger<?> trigger;
    private final GitHubSCMSource scmSource;
    private final GitHubHandler handler;

    protected GitHubDecisionContext(@NonNull TaskListener listener, GitHubTrigger<?> trigger, GitHubSCMSource scmSource, GitHubHandler handler) {
        this.listener = listener;
        this.trigger = trigger;
        this.scmSource = scmSource;
        this.handler = handler;
    }

    @NonNull
    public TaskListener getListener() {
        return this.listener;
    }

    @NonNull
    public GHRepository getRemoteRepository() throws IOException {
        GHRepository repo = null;
        if (this.scmSource != null) {
            repo = this.scmSource.getRemoteRepo();
        } else if (this.trigger != null) {
            repo = this.trigger.getRemoteRepository();
        }
        if (repo == null) {
            throw new IOException("No remote repository");
        }
        return repo;
    }

    @CheckForNull
    public GitHubSCMSource getScmSource() {
        return this.scmSource;
    }

    @CheckForNull
    public GitHubHandler getHandler() {
        return this.handler;
    }

    @CheckForNull
    public GitHubTrigger<?> getTrigger() {
        return this.trigger;
    }

    public abstract C checkEvent(E var1) throws IOException;

    public abstract C newCause(String var1, boolean var2);
}

