/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.github.kostyasha.github.integration.generic.GitHubRepository;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import com.github.kostyasha.github.integration.multibranch.revision.GitHubSCMRevision;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitHubCause<T extends GitHubCause<T>>
extends Cause {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubCause.class);
    private boolean skip;
    private String reason;
    @CheckForNull
    private URL htmlUrl;
    @CheckForNull
    private String title;
    private String gitUrl;
    private String sshUrl;
    private String pollingLog;
    private transient Object remoteData;

    public GitHubCause withLocalRepo(@NonNull GitHubRepository localRepo) {
        this.withGitUrl(localRepo.getGitUrl());
        this.withSshUrl(localRepo.getSshUrl());
        this.withHtmlUrl(localRepo.getGithubUrl());
        return this;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public GitHubCause<T> withSkip(boolean skip) {
        this.skip = skip;
        return this;
    }

    @CheckForNull
    public URL getHtmlUrl() {
        return this.htmlUrl;
    }

    public GitHubCause<T> withHtmlUrl(URL htmlUrl) {
        this.htmlUrl = htmlUrl;
        return this;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public GitHubCause<T> withGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public GitHubCause<T> withSshUrl(String sshUrl) {
        this.sshUrl = sshUrl;
        return this;
    }

    public String getPollingLog() {
        return this.pollingLog;
    }

    public GitHubCause<T> withPollingLog(String pollingLog) {
        this.pollingLog = pollingLog;
        return this;
    }

    public void setPollingLog(String pollingLog) {
        this.pollingLog = pollingLog;
    }

    public void setPollingLogFile(File logFile) throws IOException {
        this.pollingLog = FileUtils.readFileToString((File)logFile);
    }

    public String getReason() {
        return this.reason;
    }

    public GitHubCause<T> withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public Object getRemoteData() {
        return this.remoteData;
    }

    public GitHubCause<T> withRemoteData(Object remoteData) {
        this.remoteData = remoteData;
        return this;
    }

    @NonNull
    public String getTitle() {
        return Objects.nonNull(this.title) ? this.title : "";
    }

    public GitHubCause<T> withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getAbbreviatedTitle() {
        return StringUtils.abbreviate((String)this.getTitle(), (int)30);
    }

    public abstract void fillParameters(List<ParameterValue> var1);

    public abstract GitHubSCMHead<T> createSCMHead(String var1);

    public GitHubSCMRevision createSCMRevision(String sourceId) {
        return this.createSCMHead(sourceId).createSCMRevision(this).setRemoteData(this.getRemoteData());
    }

    public static <T extends GitHubCause<T>> T skipTrigger(List<? extends T> causes) {
        if (Objects.isNull(causes)) {
            return null;
        }
        GitHubCause cause = causes.stream().filter(GitHubCause::isSkip).findFirst().orElse(null);
        return (T)((Object)cause);
    }
}

