/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.generic;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.generic.GitHubDecisionContext;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubBranchHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Objects;
import org.kohsuke.github.GHBranch;

public class GitHubBranchDecisionContext
extends GitHubDecisionContext<GitHubBranchEvent, GitHubBranchCause> {
    private final GHBranch remoteBranch;
    private final GitHubBranch localBranch;
    private final GitHubBranchRepository localRepo;

    public GitHubBranchDecisionContext(GHBranch remoteBranch, GitHubBranch localBranch, @NonNull GitHubBranchRepository localRepo, GitHubBranchHandler branchHandler, GitHubSCMSource scmSource, GitHubBranchTrigger branchTrigger, TaskListener listener) {
        super(listener, branchTrigger, scmSource, branchHandler);
        this.remoteBranch = remoteBranch;
        this.localBranch = localBranch;
        this.localRepo = localRepo;
    }

    @CheckForNull
    public GHBranch getRemoteBranch() {
        return this.remoteBranch;
    }

    @CheckForNull
    public GitHubBranch getLocalBranch() {
        return this.localBranch;
    }

    @NonNull
    public GitHubBranchRepository getLocalRepo() {
        return this.localRepo;
    }

    public GitHubBranchTrigger getTrigger() {
        return (GitHubBranchTrigger)super.getTrigger();
    }

    @Override
    public GitHubBranchHandler getHandler() {
        return (GitHubBranchHandler)super.getHandler();
    }

    @Deprecated
    public GitHubBranchTrigger getBranchTrigger() {
        return this.getTrigger();
    }

    @Override
    public GitHubBranchCause checkEvent(GitHubBranchEvent event) throws IOException {
        return event.check(this);
    }

    @Override
    public GitHubBranchCause newCause(String reason, boolean skip) {
        if (this.remoteBranch != null) {
            return new GitHubBranchCause(this.remoteBranch, this.localRepo, reason, skip);
        }
        return new GitHubBranchCause(this.localBranch, this.localRepo, reason, skip);
    }

    @NonNull
    public static Builder newGitHubBranchDecisionContext() {
        return new Builder();
    }

    public static class Builder {
        private GHBranch remoteBranch = null;
        private GitHubBranch localBranch = null;
        private TaskListener listener;
        private GitHubBranchHandler branchHandler = null;
        private GitHubBranchTrigger branchTrigger = null;
        private GitHubSCMSource scmSource;
        private GitHubBranchRepository localRepo;

        public Builder withRemoteBranch(@CheckForNull GHBranch remoteBranch) {
            this.remoteBranch = remoteBranch;
            return this;
        }

        public Builder withLocalBranch(@CheckForNull GitHubBranch localBranch) {
            this.localBranch = localBranch;
            return this;
        }

        public Builder withLocalRepo(GitHubBranchRepository localRepo) {
            this.localRepo = localRepo;
            return this;
        }

        public Builder withBranchTrigger(GitHubBranchTrigger branchTrigger) {
            this.branchTrigger = branchTrigger;
            return this;
        }

        public Builder withListener(@NonNull TaskListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withBranchHandler(@CheckForNull GitHubBranchHandler branchHandler) {
            this.branchHandler = branchHandler;
            return this;
        }

        public Builder withSCMSource(GitHubSCMSource scmSource) {
            this.scmSource = scmSource;
            return this;
        }

        public GitHubBranchDecisionContext build() {
            if (Objects.isNull((Object)this.branchHandler)) {
                Objects.requireNonNull(this.branchTrigger);
            } else {
                Objects.requireNonNull(this.branchHandler);
                Objects.requireNonNull(this.scmSource);
            }
            Objects.requireNonNull(this.listener);
            return new GitHubBranchDecisionContext(this.remoteBranch, this.localBranch, this.localRepo, this.branchHandler, this.scmSource, this.branchTrigger, this.listener);
        }
    }
}

