/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.webhook;

import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.utils.JobHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Job;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.pullrequest.utils.PRHelperFunctions;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookInfoBranchPredicates {
    private WebhookInfoBranchPredicates() {
    }

    public static Predicate<Job> withBranchTrigger() {
        return Predicates.and((Predicate)JobInfoHelpers.withTrigger(GitHubBranchTrigger.class), WebhookInfoBranchPredicates.withHookTriggerMode());
    }

    public static Predicate<Job> withHookTriggerMode() {
        return new HookTriggerMode();
    }

    public static Predicate<Job> withBranchTriggerRepo(String repo) {
        return new WithBranchTriggerRepo(repo);
    }

    private static class HookTriggerMode
    implements Predicate<Job> {
        private HookTriggerMode() {
        }

        public boolean apply(Job job) {
            return Predicates.in(Arrays.asList(GitHubPRTriggerMode.HEAVY_HOOKS, GitHubPRTriggerMode.HEAVY_HOOKS_CRON, GitHubPRTriggerMode.LIGHT_HOOKS)).apply((Object)((GitHubBranchTrigger)((Object)Preconditions.checkNotNull((Object)((Object)JobHelper.ghBranchTriggerFromJob(job)), (Object)"This predicate can be applied only for job with GitHubBranchTrigger"))).getTriggerMode());
        }
    }

    private static class WithBranchTriggerRepo
    implements Predicate<Job> {
        private static final Logger LOG = LoggerFactory.getLogger(WithBranchTriggerRepo.class);
        private final String repo;

        WithBranchTriggerRepo(String repo) {
            this.repo = repo;
        }

        public boolean apply(Job job) {
            try {
                return StringUtils.equalsIgnoreCase((CharSequence)this.repo, (CharSequence)PRHelperFunctions.asFullRepoName(JobHelper.ghBranchTriggerFromJob(job).getRepoFullName(job)));
            }
            catch (Exception ex) {
                LOG.warn("Can't get GitHub repository name for {}. Have you set correct 'GitHub Project Property'?", (Object)job.getFullName(), (Object)ex);
                return false;
            }
        }
    }
}

