/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.webhook;

import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.utils.JobHelper;
import com.github.kostyasha.github.integration.branch.webhook.AbstractGHBranchSubscriber;
import com.github.kostyasha.github.integration.branch.webhook.BranchInfo;
import com.github.kostyasha.github.integration.branch.webhook.WebhookInfoBranchPredicates;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GHBranchSubscriber
extends AbstractGHBranchSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHBranchSubscriber.class);

    protected boolean isApplicable(@Nullable Item item) {
        return item instanceof Job && WebhookInfoBranchPredicates.withBranchTrigger().apply((Object)((Job)item));
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            BranchInfo ref = this.extractRefInfo(event.getGHEvent(), (String)event.getPayload());
            for (Job job : GHBranchSubscriber.getBranchTriggerJobs(ref.getRepo())) {
                GitHubBranchTrigger trigger = JobHelper.ghBranchTriggerFromJob(job);
                if (Objects.isNull((Object)trigger)) continue;
                GitHubPRTriggerMode triggerMode = trigger.getTriggerMode();
                switch (triggerMode) {
                    case HEAVY_HOOKS_CRON: 
                    case HEAVY_HOOKS: {
                        LOGGER.debug("Queued check for {} (Branch {}) after heavy hook", (Object)job.getName(), (Object)ref.getBranchName());
                        trigger.queueRun(job, ref.getBranchName());
                        break;
                    }
                    case LIGHT_HOOKS: {
                        LOGGER.warn("Unsupported LIGHT_HOOKS trigger mode");
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't process {} hook", (Object)event, (Object)e);
        }
    }

    static Set<Job> getBranchTriggerJobs(String repo) {
        HashSet<Job> ret = new HashSet<Job>();
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            List jobs = Jenkins.getInstance().getAllItems(Job.class);
            ret.addAll((Collection<Job>)FluentIterableWrapper.from((Iterable)jobs).filter(JobInfoHelpers.isBuildable()).filter(WebhookInfoBranchPredicates.withBranchTrigger()).filter(WebhookInfoBranchPredicates.withBranchTriggerRepo(repo)).toSet());
        }
        return ret;
    }
}

