/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.webhook;

import com.github.kostyasha.github.integration.branch.webhook.BranchInfo;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.kohsuke.github.GHEvent;

public abstract class AbstractGHBranchSubscriber
extends GHEventsSubscriber {
    public static final Set<GHEvent> EVENTS = Sets.immutableEnumSet((Enum)GHEvent.PUSH, (Enum[])new GHEvent[]{GHEvent.CREATE, GHEvent.DELETE});

    protected Set<GHEvent> events() {
        return EVENTS;
    }

    protected BranchInfo extractRefInfo(GHEvent event, String payload) throws IOException {
        return this.extractRefInfo(event, payload, false);
    }

    protected BranchInfo extractRefInfo(GHEvent event, String payload, boolean tagsAware) throws IOException {
        JSONObject json = JSONObject.fromObject((Object)payload);
        if (EVENTS.contains(event)) {
            return this.fromJson(json, tagsAware);
        }
        throw new IllegalStateException(String.format("Did you add event %s in events() method?", event));
    }

    protected BranchInfo fromJson(JSONObject json) {
        return this.fromJson(json, false);
    }

    protected BranchInfo fromJson(JSONObject json, boolean tagsAware) {
        JSONObject jsonRepository = json.getJSONObject("repository");
        String repo = jsonRepository.getString("full_name");
        String branchName = json.getString("ref");
        String refType = json.optString("ref_type", null);
        String fullRef = branchName;
        boolean tag = false;
        if (branchName.startsWith("refs/heads/")) {
            branchName = branchName.replace("refs/heads/", "");
        }
        if ("tag".equals(refType)) {
            tag = true;
        } else if (branchName.startsWith("refs/tags/")) {
            if (tagsAware) {
                branchName = branchName.replace("refs/tags/", "");
            }
            tag = true;
        }
        return new BranchInfo(repo, branchName, fullRef, tag);
    }
}

