/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.utils;

import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.model.Job;
import java.util.Objects;
import java.util.function.Predicate;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRRepository;

public class ItemHelpers {
    private ItemHelpers() {
    }

    public static Predicate<Item> isBuildable() {
        return item -> Objects.nonNull(item) && item instanceof Job && ((Job)item).isBuildable();
    }

    @CheckForNull
    public static GitHubBranchRepository getBranchRepositoryFor(Item item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            return (GitHubBranchRepository)job.getAction(GitHubBranchRepository.class);
        }
        return null;
    }

    @CheckForNull
    public static GitHubPRRepository getPRRepositoryFor(Item item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            return (GitHubPRRepository)job.getAction(GitHubPRRepository.class);
        }
        return null;
    }
}

