/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.trigger.check;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import java.util.function.Function;
import org.kohsuke.github.GHBranch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoUpdater
implements Function<GHBranch, GHBranch> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRepoUpdater.class);
    private final GitHubBranchRepository localRepo;

    private LocalRepoUpdater(GitHubBranchRepository localRepo) {
        this.localRepo = localRepo;
    }

    public static LocalRepoUpdater updateLocalRepo(GitHubBranchRepository localRepo) {
        return new LocalRepoUpdater(localRepo);
    }

    @Override
    public GHBranch apply(GHBranch remoteBranch) {
        LOGGER.trace("Updating local branch repository with [{}]", (Object)remoteBranch.getName());
        this.localRepo.getBranches().put(remoteBranch.getName(), new GitHubBranch(remoteBranch));
        return remoteBranch;
    }
}

