/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.trigger.check;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.multibranch.GitHubSCMSource;
import com.github.kostyasha.github.integration.multibranch.handler.GitHubBranchHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kohsuke.github.GHBranch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchToCauseConverter
implements Function<GHBranch, GitHubBranchCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BranchToCauseConverter.class);
    private final GitHubBranchRepository localBranches;
    private final TaskListener listener;
    @CheckForNull
    private final GitHubBranchTrigger trigger;
    @CheckForNull
    private final GitHubBranchHandler handler;
    private final GitHubSCMSource source;

    private BranchToCauseConverter(@NonNull GitHubBranchRepository localBranches, @NonNull TaskListener listener, @NonNull GitHubBranchTrigger trigger) {
        this.localBranches = localBranches;
        this.listener = listener;
        this.trigger = trigger;
        this.handler = null;
        this.source = null;
    }

    public BranchToCauseConverter(@NonNull GitHubBranchRepository localBranches, @NonNull TaskListener listener, @NonNull GitHubBranchHandler handler, @NonNull GitHubSCMSource source) {
        this.localBranches = localBranches;
        this.listener = listener;
        this.handler = handler;
        this.source = source;
        this.trigger = null;
    }

    public static BranchToCauseConverter toGitHubBranchCause(GitHubBranchRepository localRepo, TaskListener listener, GitHubBranchTrigger trigger) {
        return new BranchToCauseConverter(localRepo, listener, trigger);
    }

    public static BranchToCauseConverter toGitHubBranchCause(GitHubBranchRepository localRepo, TaskListener listener, @NonNull GitHubBranchHandler handler, @NonNull GitHubSCMSource source) {
        return new BranchToCauseConverter(localRepo, listener, handler, source);
    }

    private List<GitHubBranchEvent> getEvents() {
        if (Objects.nonNull((Object)this.trigger)) {
            return this.trigger.getEvents();
        }
        if (Objects.nonNull((Object)this.handler)) {
            return this.handler.getEvents();
        }
        return Collections.emptyList();
    }

    @Override
    public GitHubBranchCause apply(GHBranch remoteBranch) {
        String branchName = remoteBranch.getName();
        GitHubBranch localBranch = this.localBranches.getBranches().get(branchName);
        GitHubBranchDecisionContext context = GitHubBranchDecisionContext.newGitHubBranchDecisionContext().withListener(this.listener).withLocalRepo(this.localBranches).withRemoteBranch(remoteBranch).withLocalBranch(localBranch).withBranchTrigger(this.trigger).withBranchHandler(this.handler).withSCMSource(this.source).build();
        List causes = this.getEvents().stream().map(event -> this.toCause((GitHubBranchEvent)((Object)event), context)).filter(Objects::nonNull).collect(Collectors.toList());
        String name = remoteBranch.getName();
        if (causes.isEmpty()) {
            LOGGER.debug("No build trigger causes found for branch [{}].", (Object)name);
            return null;
        }
        LOGGER.debug("All matched events for branch [{}] : {}.", (Object)name, causes);
        GitHubBranchCause cause = (GitHubBranchCause)((Object)GitHubCause.skipTrigger(causes));
        if (cause != null) {
            LOGGER.debug("Cause [{}] indicated build should be skipped.", (Object)cause);
            this.listener.getLogger().println(String.format("Build of branch %s skipped: %s.", name, cause.getReason()));
            return null;
        }
        if (!causes.isEmpty()) {
            cause = (GitHubBranchCause)((Object)causes.get(0));
            LOGGER.debug("Using build cause [{}] as trigger for branch [{}].", (Object)cause, (Object)name);
        }
        return cause;
    }

    private GitHubBranchCause toCause(GitHubBranchEvent event, GitHubBranchDecisionContext context) {
        try {
            return context.checkEvent(event);
        }
        catch (IOException e) {
            String branch = null;
            if (Objects.nonNull(context.getLocalBranch())) {
                branch = context.getLocalBranch().getName();
            } else if (Objects.nonNull(context.getRemoteBranch())) {
                branch = context.getRemoteBranch().getName();
            }
            LOGGER.error("Event check failed, skipping branch '{}'.", (Object)branch, (Object)e);
            this.listener.error("Event check failed, skipping branch '{}' {}", new Object[]{branch, e});
            return null;
        }
    }
}

