/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.trigger;

import com.cloudbees.jenkins.GitHubWebHook;
import com.github.kostyasha.github.integration.branch.GitHubBranchBadgeAction;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.queue.QueueTaskFuture;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jenkinsci.plugins.github.pullrequest.utils.JobHelper;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GHCommitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunnerForBranchCause
implements Predicate<GitHubBranchCause> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunnerForBranchCause.class);
    private Job job;
    private GitHubBranchTrigger trigger;

    public JobRunnerForBranchCause(Job job, GitHubBranchTrigger trigger) {
        this.job = job;
        this.trigger = trigger;
    }

    public boolean apply(GitHubBranchCause cause) {
        try {
            QueueTaskFuture<?> queueTaskFuture;
            cause.setPollingLogFile(this.trigger.getPollingLogAction().getPollingLogFile());
            StringBuilder sb = new StringBuilder();
            sb.append("Jenkins queued the run (").append(cause.getReason()).append(")");
            if (this.trigger.isCancelQueued() && JobRunnerForBranchCause.cancelQueuedBuildByBranchName(cause.getBranchName())) {
                sb.append(". Queued builds aborted");
            }
            if (Objects.isNull(queueTaskFuture = this.startJob(cause))) {
                LOGGER.error("{} job didn't start", (Object)this.job.getFullName());
            }
            LOGGER.info(sb.toString());
            if (this.trigger.isPreStatus()) {
                this.trigger.getRemoteRepository().createCommitStatus(cause.getCommitSha(), GHCommitState.PENDING, null, sb.toString(), this.job.getFullName());
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't trigger build ({})", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    private static boolean cancelQueuedBuildByBranchName(String branch) {
        Queue queue = GitHubWebHook.getJenkinsInstance().getQueue();
        for (Queue.Item item : queue.getItems()) {
            Optional cause = FluentIterableWrapper.from((Iterable)item.getAllActions()).filter(Predicates.instanceOf(CauseAction.class)).transformAndConcat((Function)new CausesFromAction()).filter(Predicates.instanceOf(GitHubBranchCause.class)).firstMatch((Predicate)new CauseHasBranch(branch));
            if (!cause.isPresent()) continue;
            queue.cancel(item);
            return true;
        }
        return false;
    }

    public QueueTaskFuture<?> startJob(GitHubBranchCause cause) {
        return this.startJob(cause, null);
    }

    public QueueTaskFuture<?> startJob(GitHubBranchCause cause, Cause additionalCause) {
        ParametersAction parametersAction;
        List<ParameterValue> parameters = JobHelper.getDefaultParametersValues(this.job);
        cause.fillParameters(parameters);
        try {
            Constructor constructor = ParametersAction.class.getConstructor(List.class, Collection.class);
            HashSet<String> names = new HashSet<String>();
            for (ParameterValue param : parameters) {
                names.add(param.getName());
            }
            parametersAction = (ParametersAction)constructor.newInstance(parameters, names);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            parametersAction = new ParametersAction(parameters);
        }
        GitHubBranchBadgeAction gitHubBadgeAction = new GitHubBranchBadgeAction(cause);
        ParameterizedJobMixIn parameterizedJobMixIn = JobInfoHelpers.asParameterizedJobMixIn((Job)this.job);
        int quietPeriod = 0;
        try {
            Object mixinJob = FieldUtils.readField((Object)parameterizedJobMixIn, (String)"val$job", (boolean)true);
            ParameterizedJobMixIn.ParameterizedJob parameterizedJob = (ParameterizedJobMixIn.ParameterizedJob)mixinJob;
            quietPeriod = parameterizedJob.getQuietPeriod();
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Couldn't extract quiet period, falling back to {}", (Object)quietPeriod, (Object)e);
        }
        CauseAction causeAction = Objects.nonNull(additionalCause) ? new CauseAction(new Cause[]{cause, additionalCause}) : new CauseAction((Cause)cause);
        return JobInfoHelpers.asParameterizedJobMixIn((Job)this.job).scheduleBuild2(quietPeriod, new Action[]{causeAction, parametersAction, gitHubBadgeAction});
    }

    private static class CausesFromAction
    implements Function<Action, Iterable<Cause>> {
        private CausesFromAction() {
        }

        public Iterable<Cause> apply(Action input) {
            return ((CauseAction)input).getCauses();
        }
    }

    private static class CauseHasBranch
    implements Predicate<Cause> {
        private final String branch;

        CauseHasBranch(String branch) {
            this.branch = branch;
        }

        public boolean apply(Cause cause) {
            return ((GitHubBranchCause)cause).getBranchName().equals(this.branch);
        }
    }
}

