/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl.commitchecks.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.impl.commitchecks.GitHubBranchCommitCheck;
import com.github.kostyasha.github.integration.branch.events.impl.commitchecks.GitHubBranchCommitCheckDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionPoint;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCompare;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchCommitMessageCheck
extends GitHubBranchCommitCheck
implements ExtensionPoint {
    private static final String DISPLAY_NAME = "Commit Message Pattern";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchCommitMessageCheck.class);
    private boolean exclude;
    private Set<String> matchCriteria = Collections.emptySet();

    @DataBoundConstructor
    public GitHubBranchCommitMessageCheck() {
    }

    @Override
    public GitHubBranchCause doCheck(GHBranch remoteBranch, GitHubBranchRepository localRepo, GHCommit commit) throws IOException {
        List<String> messages = Arrays.asList(commit.getCommitShortInfo().getMessage());
        return this.check(remoteBranch, localRepo, () -> messages);
    }

    @Override
    public GitHubBranchCause check(GHBranch remoteBranch, GitHubBranchRepository localRepo, GHCompare.Commit[] commits) {
        return this.check(remoteBranch, localRepo, () -> Stream.of(commits).map(commit -> commit.getCommit().getMessage()).collect(Collectors.toList()));
    }

    public String getMatchCriteria() {
        return String.join((CharSequence)LINE_SEPARATOR, this.matchCriteria);
    }

    public boolean isExclude() {
        return this.exclude;
    }

    @DataBoundSetter
    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    @DataBoundSetter
    public void setMatchCriteria(String matchCriteria) {
        this.matchCriteria = Stream.of(matchCriteria.split(LINE_SEPARATOR)).collect(Collectors.toSet());
    }

    private <T> GitHubBranchCause check(GHBranch remoteBranch, GitHubBranchRepository localRepo, Supplier<List<String>> supplier) {
        if (this.matchCriteria.isEmpty()) {
            LOG.warn("Commit message event added but no match criteria set, all commits are allowed.");
            return null;
        }
        String name = remoteBranch.getName();
        List<String> messages = supplier.get();
        if (this.commitsAreAllowed(messages)) {
            LOG.debug("Commit messages {} for branch [{}] allowed, commit ignored.", messages, (Object)name);
            return null;
        }
        return this.toCause(remoteBranch, localRepo, true, "Commit messages %s for branch [%s] not allowed by check.", messages, name);
    }

    private boolean commitsAreAllowed(List<String> messages) {
        boolean allowed = false;
        for (String message : messages) {
            if (!this.commitIsAllowed(message)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    private boolean commitIsAllowed(String message) {
        for (String pattern : this.matchCriteria) {
            LOG.debug("Checking commit [{}] against pattern [{}] - exclude [{}]", new Object[]{message, pattern, this.exclude});
            if (!this.matches(message, pattern)) continue;
            if (this.exclude) {
                LOG.debug("Commit [{}] matches pattern [{}], will be excluded", (Object)message, (Object)pattern);
                return false;
            }
            LOG.debug("Commit [{}] matched pattern [{}] and is marked for inclusion", (Object)message, (Object)pattern);
            return true;
        }
        LOG.debug("Commit [{}] matched no patterns, included [{}]", (Object)message, (Object)this.exclude);
        return this.exclude;
    }

    private boolean matches(String message, String pattern) {
        try {
            return Pattern.compile(pattern).matcher(message).matches();
        }
        catch (PatternSyntaxException e) {
            LOG.error("Invalid pattern [{}] detected checking commit [{}]", new Object[]{pattern, message, e});
            return false;
        }
    }

    private GitHubBranchCause toCause(GHBranch remoteBranch, GitHubBranchRepository localRepo, boolean skip, String message, Object ... args) {
        return new GitHubBranchCause(remoteBranch, localRepo, String.format(message, args), skip);
    }

    @Symbol(value={"commitMessagePattern"})
    @Extension
    public static class DescriptorImpl
    extends GitHubBranchCommitCheckDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubBranchCommitMessageCheck.DISPLAY_NAME;
        }
    }
}

