/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl.commitchecks;

import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.impl.commitchecks.GitHubBranchCommitCheckDescriptor;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import java.io.IOException;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCompare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitHubBranchCommitCheck
extends AbstractDescribableImpl<GitHubBranchCommitCheck>
implements ExtensionPoint {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchCommitCheck.class);

    public GitHubBranchCommitCheckDescriptor getDescriptor() {
        return (GitHubBranchCommitCheckDescriptor)super.getDescriptor();
    }

    public abstract GitHubBranchCause check(GHBranch var1, GitHubBranchRepository var2, GHCompare.Commit[] var3);

    public GitHubBranchCause check(GHBranch remoteBranch, GitHubBranchRepository localRepo, GHCommit commit) {
        try {
            return this.doCheck(remoteBranch, localRepo, commit);
        }
        catch (IOException e) {
            LOG.error("Failed to check commit for hash [{}]", (Object)commit.getSHA1(), (Object)e);
            return new GitHubBranchCause(remoteBranch, localRepo, e.getMessage(), true);
        }
    }

    protected abstract GitHubBranchCause doCheck(GHBranch var1, GitHubBranchRepository var2, GHCommit var3) throws IOException;
}

