/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHBranch;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchRestrictionFilter
extends GitHubBranchEvent {
    private static final String DISPLAY_NAME = "Branch Restrictions";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubBranchRestrictionFilter.class);
    private boolean exclude;
    private boolean matchAsPattern;
    private Set<String> matchCriteria;

    @DataBoundConstructor
    public GitHubBranchRestrictionFilter() {
    }

    public String getMatchCriteriaStr() {
        return String.join((CharSequence)LINE_SEPARATOR, this.matchCriteria);
    }

    @DataBoundSetter
    public void setMatchCriteriaStr(String matchCriteria) {
        this.matchCriteria = Stream.of(matchCriteria.split(LINE_SEPARATOR)).collect(Collectors.toSet());
    }

    public boolean isExclude() {
        return this.exclude;
    }

    @DataBoundSetter
    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isMatchAsPattern() {
        return this.matchAsPattern;
    }

    @DataBoundSetter
    public void setMatchAsPattern(boolean matchAsPattern) {
        this.matchAsPattern = matchAsPattern;
    }

    public Set<String> getMatchCriteria() {
        return this.matchCriteria;
    }

    @Override
    public GitHubBranchCause check(@NonNull GitHubBranchDecisionContext context) throws IOException {
        GHBranch remoteBranch = context.getRemoteBranch();
        GitHubBranchRepository localRepo = context.getLocalRepo();
        String name = remoteBranch.getName();
        if (this.matchCriteria.isEmpty() || this.branchIsAllowed(name)) {
            if (this.matchCriteria.isEmpty()) {
                LOGGER.warn("Branch restriction filter added but no match criteria set, all branches allowed");
            }
            return null;
        }
        return this.toCause(context, true, "Branch [%s] filtered by branch name restriction filter", name);
    }

    private boolean branchIsAllowed(String name) {
        for (String pattern : this.matchCriteria) {
            LOGGER.trace("Checking branch [{}] against pattern [{}] - exclude [{}]", new Object[]{name, pattern, this.exclude});
            if (!this.matches(name, pattern)) continue;
            if (this.exclude) {
                LOGGER.debug("Branch [{}] matches pattern [{}], will be excluded", (Object)name, (Object)pattern);
                return false;
            }
            LOGGER.debug("Branch [%s] matched pattern [{}] and is marked for inclusion", (Object)name, (Object)pattern);
            return true;
        }
        LOGGER.trace("Branch [{}] matched no patterns, included [{}]", (Object)name, (Object)this.exclude);
        return this.exclude;
    }

    private boolean matches(String name, String pattern) {
        if (!this.matchAsPattern) {
            LOGGER.debug("Checking branch [{}] against exact match [{}]", (Object)name, (Object)pattern);
            return name.equals(pattern);
        }
        try {
            LOGGER.debug("Checking branch [{}] against pattern [{}].", (Object)name, (Object)pattern);
            return Pattern.compile(pattern).matcher(name).matches();
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Invalid pattern [{}] detected checking branch [{}]", new Object[]{pattern, name, e});
            return false;
        }
    }

    private GitHubBranchCause toCause(@NonNull GitHubBranchDecisionContext context, boolean skip, String message, Object ... args) {
        return context.newCause(String.format(message, args), skip);
    }

    @Symbol(value={"restriction"})
    @Extension
    public static class Descriptor
    extends GitHubBranchEventDescriptor {
        @NonNull
        public String getDisplayName() {
            return GitHubBranchRestrictionFilter.DISPLAY_NAME;
        }
    }
}

