/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHBranch;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchHashChangedEvent
extends GitHubBranchEvent {
    private static final String DISPLAY_NAME = "Hash Changed";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchHashChangedEvent.class);

    @DataBoundConstructor
    public GitHubBranchHashChangedEvent() {
    }

    @Override
    public GitHubBranchCause check(@NonNull GitHubBranchDecisionContext context) throws IOException {
        String remoteBranchSHA1;
        String localBranchSHA1;
        GHBranch remoteBranch = context.getRemoteBranch();
        GitHubBranch localBranch = context.getLocalBranch();
        TaskListener listener = context.getListener();
        GitHubBranchCause cause = null;
        if (Objects.nonNull(localBranch) && Objects.nonNull(remoteBranch) && !(localBranchSHA1 = localBranch.getCommitSha()).equals(remoteBranchSHA1 = remoteBranch.getSHA1())) {
            PrintStream logger = listener.getLogger();
            logger.printf("%s: hash has changed '%s' -> '%s'%n", DISPLAY_NAME, localBranchSHA1, remoteBranchSHA1);
            LOG.debug("{}: hash has changed '{}' -> '{}'", new Object[]{DISPLAY_NAME, localBranchSHA1, remoteBranchSHA1});
            cause = context.newCause(DISPLAY_NAME, false);
        }
        return cause;
    }

    @Symbol(value={"hashChanged"})
    @Extension
    public static class DescriptorImpl
    extends GitHubBranchEventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubBranchHashChangedEvent.DISPLAY_NAME;
        }
    }
}

