/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHBranch;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchDeletedEvent
extends GitHubBranchEvent {
    private static final String DISPLAY_NAME = "Branch Deleted";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchDeletedEvent.class);

    @DataBoundConstructor
    public GitHubBranchDeletedEvent() {
    }

    @Override
    public GitHubBranchCause check(@NonNull GitHubBranchDecisionContext context) throws IOException {
        TaskListener listener = context.getListener();
        GitHubBranch localBranch = context.getLocalBranch();
        GHBranch remoteBranch = context.getRemoteBranch();
        GitHubBranchCause cause = null;
        if (Objects.nonNull(localBranch) && Objects.isNull(remoteBranch)) {
            PrintStream logger = listener.getLogger();
            logger.println("Branch Deleted: state has changed (branch was deleted)");
            LOG.debug("{}: state has changed (branch was deleted)", (Object)DISPLAY_NAME);
            localBranch.setCommitSha(null);
            cause = context.newCause(DISPLAY_NAME, false);
        }
        return cause;
    }

    @Symbol(value={"deleted"})
    @Extension
    public static class DescriptorImpl
    extends GitHubBranchEventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubBranchDeletedEvent.DISPLAY_NAME;
        }
    }
}

