/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.kohsuke.github.GHBranch;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchCreatedEvent
extends GitHubBranchEvent {
    private static final String DISPLAY_NAME = "Branch Created";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchCreatedEvent.class);

    @DataBoundConstructor
    public GitHubBranchCreatedEvent() {
    }

    @Override
    public GitHubBranchCause check(@NonNull GitHubBranchDecisionContext context) throws IOException {
        GHBranch remoteBranch = context.getRemoteBranch();
        GitHubBranch localBranch = context.getLocalBranch();
        TaskListener listener = context.getListener();
        if (Objects.isNull(remoteBranch) && Objects.isNull(localBranch)) {
            LOG.debug("Remote and local branch are null");
            return null;
        }
        if (Objects.isNull(remoteBranch)) {
            LOG.debug("Remote branch is null for localBranch '{}'. Branch can't be 'created'", (Object)localBranch.getName());
            return null;
        }
        GitHubBranchCause cause = null;
        if (Objects.isNull(localBranch)) {
            PrintStream logger = listener.getLogger();
            logger.println("Branch Created: '" + remoteBranch.getName() + "'");
            LOG.debug("{}: '{}'", (Object)DISPLAY_NAME, (Object)remoteBranch.getName());
            cause = context.newCause(DISPLAY_NAME, false);
        }
        return cause;
    }

    @Symbol(value={"branchCreated"})
    @Extension
    public static class DescriptorImpl
    extends GitHubBranchEventDescriptor {
        @NonNull
        public final String getDisplayName() {
            return GitHubBranchCreatedEvent.DISPLAY_NAME;
        }
    }
}

