/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.events.impl;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.branch.events.impl.commitchecks.GitHubBranchCommitCheck;
import com.github.kostyasha.github.integration.branch.events.impl.commitchecks.GitHubBranchCommitCheckDescriptor;
import com.github.kostyasha.github.integration.generic.GitHubBranchDecisionContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCompare;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchCommitEvent
extends GitHubBranchEvent {
    private static final String DISPLAY_NAME = "Commit Checks";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchCommitEvent.class);
    private List<GitHubBranchCommitCheck> checks = new ArrayList<GitHubBranchCommitCheck>();

    @Restricted(value={NoExternalUse.class})
    public GitHubBranchCommitEvent() {
    }

    @DataBoundConstructor
    public GitHubBranchCommitEvent(List<GitHubBranchCommitCheck> checks) {
        this.checks = checks;
    }

    @Override
    public GitHubBranchCause check(@NonNull GitHubBranchDecisionContext context) throws IOException {
        Function<GitHubBranchCommitCheck, GitHubBranchCause> function;
        GHBranch remoteBranch = context.getRemoteBranch();
        GitHubBranch localBranch = context.getLocalBranch();
        GitHubBranchRepository localRepo = context.getLocalRepo();
        TaskListener listener = context.getListener();
        PrintStream logger = listener.getLogger();
        if (Objects.isNull(localBranch)) {
            GHCommit commit = this.getLastCommit(remoteBranch);
            function = event -> event.check(remoteBranch, localRepo, commit);
        } else {
            GHCompare.Commit[] commits = this.getComparedCommits(localBranch, remoteBranch);
            function = event -> event.check(remoteBranch, localRepo, commits);
        }
        return this.check(remoteBranch, function, logger);
    }

    GHCompare.Commit[] getComparedCommits(GitHubBranch localBranch, GHBranch remoteBranch) throws IOException {
        String previous = localBranch.getCommitSha();
        String current = remoteBranch.getSHA1();
        LOG.debug("Comparing previous hash [{}] with current hash [{}]", (Object)previous, (Object)current);
        return remoteBranch.getOwner().getCompare(previous, current).getCommits();
    }

    GHCommit getLastCommit(GHBranch remoteBranch) throws IOException {
        return remoteBranch.getOwner().getCommit(remoteBranch.getSHA1());
    }

    @NonNull
    public List<GitHubBranchCommitCheck> getChecks() {
        if (Objects.isNull(this.checks)) {
            this.checks = new ArrayList<GitHubBranchCommitCheck>();
        }
        return this.checks;
    }

    public void setChecks(List<GitHubBranchCommitCheck> checks) {
        this.checks = checks;
    }

    private GitHubBranchCause check(GHBranch remoteBranch, Function<GitHubBranchCommitCheck, GitHubBranchCause> function, PrintStream logger) {
        List causes = this.getChecks().stream().map(function::apply).filter(Objects::nonNull).collect(Collectors.toList());
        String name = remoteBranch.getName();
        if (causes.isEmpty()) {
            LOG.debug("Commits for branch [{}] had no effect, not triggering run.", (Object)name);
            return null;
        }
        GitHubBranchCause cause = (GitHubBranchCause)((Object)causes.get(0));
        LOG.info("Building branch [{}] skipped due to commit check: {}", (Object)name, (Object)cause.getReason());
        logger.printf("Building branch [%s] skipped due to commit check: %s", name, cause.getReason());
        return cause;
    }

    @Symbol(value={"commit"})
    @Extension
    public static class DescriptorImpl
    extends GitHubBranchEventDescriptor {
        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        @NonNull
        public final String getDisplayName() {
            return GitHubBranchCommitEvent.DISPLAY_NAME;
        }

        public List<GitHubBranchCommitCheckDescriptor> getEventDescriptors() {
            return GitHubBranchCommitCheckDescriptor.all();
        }
    }
}

