/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch.data;

import com.github.kostyasha.github.integration.branch.AbstractGitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.generic.GitHubCause;
import com.github.kostyasha.github.integration.generic.GitHubEnv;
import com.github.kostyasha.github.integration.generic.GitHubRepoEnv;
import hudson.model.ParameterValue;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public enum GitHubBranchEnv implements GitHubEnv<GitHubBranchCause>
{
    NAME(GitHubBranchCause::getBranchName),
    SHORT_DESC(GitHubBranchCause::getShortDescription),
    TITLE(GitHubCause::getTitle),
    URL(c -> Objects.isNull(c.getHtmlUrl()) ? "" : c.getHtmlUrl().toString()),
    HEAD_SHA(AbstractGitHubBranchCause::getCommitSha),
    FULL_REF(AbstractGitHubBranchCause::getFullRef),
    CAUSE_SKIP(GitHubCause::isSkip);

    public static final String PREFIX = "GITHUB_BRANCH_";
    private Function<GitHubBranchCause, ParameterValue> fun;

    private GitHubBranchEnv(Function<GitHubBranchCause, String> fun) {
        this.fun = c -> this.param((String)fun.apply((GitHubBranchCause)((Object)c)));
    }

    private GitHubBranchEnv(Predicate<GitHubBranchCause> fun) {
        this.fun = c -> this.param(fun.test((GitHubBranchCause)((Object)c)));
    }

    @Override
    public void addParam(GitHubBranchCause cause, List<ParameterValue> params) {
        params.add(this.fun.apply(cause));
    }

    public String toString() {
        return PREFIX.concat(this.name());
    }

    public static void getParams(GitHubBranchCause cause, List<ParameterValue> params) {
        GitHubEnv.getParams(GitHubBranchEnv.class, cause, params);
        GitHubEnv.getParams(GitHubRepoEnv.class, cause, params);
    }
}

