/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch;

import antlr.ANTLRException;
import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchPollingLogAction;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEvent;
import com.github.kostyasha.github.integration.branch.events.GitHubBranchEventDescriptor;
import com.github.kostyasha.github.integration.branch.trigger.JobRunnerForBranchCause;
import com.github.kostyasha.github.integration.branch.trigger.check.BranchToCauseConverter;
import com.github.kostyasha.github.integration.branch.trigger.check.LocalRepoUpdater;
import com.github.kostyasha.github.integration.branch.trigger.check.SkipFirstRunForBranchFilter;
import com.github.kostyasha.github.integration.branch.utils.ItemHelpers;
import com.github.kostyasha.github.integration.branch.webhook.WebhookInfoBranchPredicates;
import com.github.kostyasha.github.integration.generic.GitHubTrigger;
import com.github.kostyasha.github.integration.generic.GitHubTriggerDescriptor;
import com.github.kostyasha.github.integration.generic.errors.impl.GitHubHookRegistrationError;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTriggerMode;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRBranchRestriction;
import org.jenkinsci.plugins.github.pullrequest.restrictions.GitHubPRUserRestriction;
import org.jenkinsci.plugins.github.pullrequest.utils.LoggingTaskListenerWrapper;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchTrigger
extends GitHubTrigger<GitHubBranchTrigger> {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchTrigger.class);
    public static final String FINISH_MSG = "Finished GitHub Branch trigger check";
    private List<GitHubBranchEvent> events = new ArrayList<GitHubBranchEvent>();
    private boolean preStatus = false;
    @CheckForNull
    private GitHubPRUserRestriction userRestriction;
    @CheckForNull
    private GitHubPRBranchRestriction branchRestriction;
    @CheckForNull
    private transient GitHubBranchPollingLogAction pollingLogAction;

    @Override
    public String getFinishMsg() {
        return FINISH_MSG;
    }

    @Restricted(value={NoExternalUse.class})
    public GitHubBranchTrigger() throws ANTLRException {
        super("");
    }

    @DataBoundConstructor
    public GitHubBranchTrigger(String spec, GitHubPRTriggerMode triggerMode, List<GitHubBranchEvent> events) throws ANTLRException {
        super(spec, triggerMode);
        this.events = events;
    }

    @DataBoundSetter
    public void setPreStatus(boolean preStatus) {
        this.preStatus = preStatus;
    }

    public boolean isPreStatus() {
        return this.preStatus;
    }

    @NonNull
    public List<GitHubBranchEvent> getEvents() {
        return Objects.nonNull(this.events) ? this.events : Collections.emptyList();
    }

    @CheckForNull
    public void setEvents(List<GitHubBranchEvent> events) {
        this.events = events;
    }

    @Override
    public void start(Job item, boolean newInstance) {
        LOG.info("Starting GitHub Branch trigger for project {}", (Object)item.getFullName());
        super.start(item, newInstance);
        if (newInstance && this.getRepoProvider().isManageHooks(this) && WebhookInfoBranchPredicates.withHookTriggerMode().apply((Object)item)) {
            try {
                this.getRepoProvider().registerHookFor(this);
                this.getErrorsAction().removeErrors(GitHubHookRegistrationError.class);
            }
            catch (Throwable error) {
                this.getErrorsAction().addOrReplaceError(new GitHubHookRegistrationError(String.format("Failed register hook for %s. <br/> Because %s", item.getFullName(), error.toString())));
                throw error;
            }
        }
    }

    public void run() {
        if (this.getTriggerMode() != GitHubPRTriggerMode.LIGHT_HOOKS) {
            this.queueRun(null);
        }
    }

    @Override
    public void doRun() {
        this.doRun(null);
    }

    @Override
    @CheckForNull
    public GitHubBranchPollingLogAction getPollingLogAction() {
        if (Objects.isNull(this.pollingLogAction) && Objects.nonNull(this.job)) {
            this.pollingLogAction = new GitHubBranchPollingLogAction((Job)this.job);
        }
        return this.pollingLogAction;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public void queueRun(Job<?, ?> job, String branch) {
        this.job = job;
        this.queueRun(branch);
    }

    public void queueRun(String branch) {
        this.getDescriptor().getQueue().execute(() -> this.doRun(branch));
    }

    public synchronized void doRun(String branch) {
        if (!ItemHelpers.isBuildable().test(this.job)) {
            LOG.debug("Job {} is disabled, but trigger run!", (Object)(Objects.isNull(this.job) ? "<no job>" : ((Job)this.job).getFullName()));
            return;
        }
        if (!GitHubBranchTrigger.isSupportedTriggerMode(this.getTriggerMode())) {
            LOG.warn("Trigger mode {} is not supported yet ({})", (Object)this.getTriggerMode(), (Object)((Job)this.job).getFullName());
            return;
        }
        GitHubBranchRepository localRepository = ItemHelpers.getBranchRepositoryFor(this.job);
        if (Objects.isNull(localRepository)) {
            LOG.warn("Can't get repository info, maybe project {} misconfigured?", (Object)((Job)this.job).getFullName());
            return;
        }
        try (LoggingTaskListenerWrapper listener = new LoggingTaskListenerWrapper(this.getPollingLogAction().getPollingLogFile(), Charsets.UTF_8);){
            long startTime = System.currentTimeMillis();
            listener.debug("Running GitHub Branch trigger check for {} on {}", DateFormat.getDateTimeInstance().format(new Date(startTime)), localRepository.getFullName());
            try {
                localRepository.actualise(this.getRemoteRepository(), (TaskListener)listener);
                List<GitHubBranchCause> causes = this.readyToBuildCauses(localRepository, listener, branch);
                localRepository.saveQuietly();
                FluentIterableWrapper.from(causes).filter((Predicate)new JobRunnerForBranchCause((Job)this.job, this)).toSet();
            }
            catch (Throwable t) {
                listener.error("Can't end trigger check!", t);
            }
            long duration = System.currentTimeMillis() - startTime;
            listener.info("Finished GitHub Branch trigger check for {} at {}. Duration: {}ms", localRepository.getFullName(), DateFormat.getDateTimeInstance().format(new Date()), duration);
        }
        catch (Exception e) {
            LOG.error("Can't process check: {}", (Throwable)e);
        }
    }

    private List<GitHubBranchCause> readyToBuildCauses(GitHubBranchRepository localRepository, LoggingTaskListenerWrapper listener, @Nullable String requestedBranch) {
        try {
            GitHub github = this.getRepoProvider().getGitHub(this);
            if (Objects.isNull(github)) {
                LOG.error("GitHub connection is null, check Repo Providers!");
                throw new IllegalStateException("GitHub connection is null, check Repo Providers!");
            }
            GHRateLimit rateLimitBefore = github.getRateLimit();
            listener.debug("GitHub rate limit before check: {}", rateLimitBefore);
            GHRepository remoteRepo = this.getRemoteRepository();
            Set<GHBranch> remoteBranches = this.branchesToCheck(requestedBranch, remoteRepo, localRepository);
            List<GitHubBranchCause> causes = this.checkBranches(remoteBranches, localRepository, listener);
            GitHubBranchTrigger.updateLocalRepository(requestedBranch, remoteBranches, localRepository);
            this.saveIfSkipFirstRun();
            GHRateLimit rateLimitAfter = github.getRateLimit();
            int consumed = rateLimitBefore.remaining - rateLimitAfter.remaining;
            LOG.info("GitHub rate limit after check {}: {}, consumed: {}, checked branches: {}", new Object[]{localRepository.getFullName(), rateLimitAfter, consumed, remoteBranches.size()});
            return causes;
        }
        catch (IOException e) {
            listener.error("Can't get build causes: '{}'", e);
            return Collections.emptyList();
        }
    }

    private Set<GHBranch> branchesToCheck(@CheckForNull String branch, @NonNull GHRepository remoteRepo, GitHubBranchRepository localRepository) throws IOException {
        LinkedHashSet<GHBranch> ghBranches = new LinkedHashSet<GHBranch>();
        if (branch != null) {
            try {
                GHBranch ghBranch = remoteRepo.getBranch(branch);
                if (ghBranch != null) {
                    ghBranches.add(ghBranch);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            ghBranches.addAll(remoteRepo.getBranches().values());
        }
        return ghBranches;
    }

    private List<GitHubBranchCause> checkBranches(Set<GHBranch> remoteBranches, GitHubBranchRepository localRepository, LoggingTaskListenerWrapper listener) {
        List<GitHubBranchCause> causes = remoteBranches.stream().filter(SkipFirstRunForBranchFilter.ifSkippedFirstRun(listener, this.skipFirstRun)).filter(Objects::nonNull).map(BranchToCauseConverter.toGitHubBranchCause(localRepository, (TaskListener)listener, this)).filter(Objects::nonNull).collect(Collectors.toList());
        LOG.debug("Build trigger count for [{}] : {}", (Object)localRepository.getFullName(), (Object)causes.size());
        return causes;
    }

    public static void updateLocalRepository(@CheckForNull String requestedBranch, Set<GHBranch> remoteBranches, GitHubBranchRepository localRepository) {
        Map<String, GitHubBranch> localBranches;
        remoteBranches.forEach(branch -> LocalRepoUpdater.updateLocalRepo(localRepository).apply((GHBranch)branch));
        LOG.trace("Updated local branch details with [{}] repositories.", (Object)remoteBranches.size());
        if (Objects.nonNull(requestedBranch)) {
            localBranches = new HashMap<String, GitHubBranch>();
            if (localRepository.getBranches().containsKey(requestedBranch)) {
                localBranches.put(requestedBranch, localRepository.getBranches().get(requestedBranch));
            }
        } else {
            localBranches = localRepository.getBranches();
        }
        Iterator<String> iterator = localBranches.keySet().iterator();
        while (iterator.hasNext()) {
            String localBranch = iterator.next();
            boolean present = remoteBranches.stream().filter(br -> br.getName().equals(localBranch)).findFirst().isPresent();
            if (present) continue;
            LOG.debug("Removing {}, from localBranches", (Object)localBranch);
            iterator.remove();
        }
    }

    private static boolean isSupportedTriggerMode(GitHubPRTriggerMode mode) {
        return mode != GitHubPRTriggerMode.LIGHT_HOOKS;
    }

    @Symbol(value={"githubBranches"})
    @Extension
    public static class DescriptorImpl
    extends GitHubTriggerDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "GitHub Branches";
        }

        public List<GitHubBranchEventDescriptor> getEventDescriptors() {
            return GitHubBranchEventDescriptor.all();
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Trigger.all().get(DescriptorImpl.class));
        }
    }
}

