/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.utils.JobHelper;
import com.github.kostyasha.github.integration.generic.GitHubRepositoryFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jenkinsci.plugins.github.pullrequest.GitHubPRTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubBranchRepositoryFactory
extends GitHubRepositoryFactory<GitHubBranchRepositoryFactory, GitHubBranchTrigger> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubBranchRepositoryFactory.class);

    @NonNull
    public Collection<? extends Action> createFor(@NonNull Job job) {
        try {
            if (Objects.nonNull((Object)JobHelper.ghBranchTriggerFromJob(job))) {
                return Collections.singleton(GitHubBranchRepositoryFactory.forProject(job));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Bad configured project {} - {}", new Object[]{job.getFullName(), ex.getMessage(), ex});
        }
        return Collections.emptyList();
    }

    @NonNull
    private static GitHubBranchRepository forProject(@NonNull Job<?, ?> job) throws IOException {
        GitHubBranchRepository localRepository;
        XmlFile configFile = new XmlFile(new File(job.getRootDir(), GitHubBranchRepository.FILE));
        GitHubBranchTrigger trigger = JobHelper.ghBranchTriggerFromJob(job);
        Objects.requireNonNull(trigger, "Can't extract Branch trigger from " + job.getFullName());
        GitHubRepositoryName repoFullName = trigger.getRepoFullName(job);
        GithubProjectProperty property = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        String githubUrl = property.getProjectUrl().toString();
        boolean created = false;
        if (configFile.exists()) {
            try {
                localRepository = (GitHubBranchRepository)configFile.read();
            }
            catch (IOException e) {
                LOGGER.info("Can't read saved repository, re-creating new one", (Throwable)e);
                localRepository = new GitHubBranchRepository(repoFullName.toString(), new URL(githubUrl));
                created = true;
            }
        } else {
            LOGGER.info("Creating new Branch Repository for '{}'", (Object)job.getFullName());
            localRepository = new GitHubBranchRepository(repoFullName.toString(), new URL(githubUrl));
            created = true;
        }
        localRepository.setJob(job);
        localRepository.setConfigFile(configFile);
        GitHubPRTrigger.DescriptorImpl prTriggerDescriptor = GitHubPRTrigger.DescriptorImpl.get();
        if (prTriggerDescriptor.isActualiseOnFactory()) {
            try {
                localRepository.actualise(trigger.getRemoteRepository(), TaskListener.NULL);
                created = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (created) {
            localRepository.save();
        }
        return localRepository;
    }
}

