/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch;

import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranchTrigger;
import com.github.kostyasha.github.integration.branch.trigger.JobRunnerForBranchCause;
import com.github.kostyasha.github.integration.branch.utils.JobHelper;
import com.github.kostyasha.github.integration.generic.GitHubRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.util.FormValidation;
import hudson.util.RunList;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchRepository
extends GitHubRepository<GitHubBranchRepository> {
    public static final String FILE = GitHubBranchRepository.class.getName() + ".runtime.xml";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchRepository.class);
    private Map<String, GitHubBranch> branches = new ConcurrentHashMap<String, GitHubBranch>();

    public GitHubBranchRepository(GHRepository remoteRepository) throws IOException {
        super(remoteRepository);
    }

    public GitHubBranchRepository(String repoFullName, URL url) {
        super(repoFullName, url);
    }

    @NonNull
    public Map<String, GitHubBranch> getBranches() {
        if (Objects.isNull(this.branches)) {
            this.branches = new ConcurrentHashMap<String, GitHubBranch>();
        }
        return this.branches;
    }

    @Override
    public void actualiseOnChange(@NonNull GHRepository ghRepository, @NonNull TaskListener listener) {
        if (this.changed) {
            listener.getLogger().println("Local settings changed, removing branches in repository!");
            this.getBranches().clear();
        }
    }

    public String getIconFileName() {
        return GitHubBranch.getIconFileName();
    }

    public String getDisplayName() {
        return "GitHub Branches";
    }

    public String getUrlName() {
        return "github-branch";
    }

    public Map<String, List<Run<?, ?>>> getAllBranchBuilds() {
        HashMap map = new HashMap();
        RunList runs = this.job.getBuilds();
        LOG.debug("Got builds for job {}", (Object)this.job.getFullName());
        for (Run run : runs) {
            GitHubBranchCause cause = JobHelper.ghBranchCauseFromRun(run);
            if (cause == null) continue;
            String branchName = cause.getBranchName();
            ArrayList<Run> buildsByBranchName = (ArrayList<Run>)map.get(branchName);
            if (Objects.isNull(buildsByBranchName)) {
                buildsByBranchName = new ArrayList<Run>();
                map.put(branchName, buildsByBranchName);
            }
            buildsByBranchName.add(run);
        }
        return map;
    }

    @Override
    @RequirePOST
    public FormValidation doClearRepo() throws IOException {
        FormValidation result;
        LOG.debug("Got clear GitHub Branch repo request for {}", (Object)this.getJob().getFullName());
        try {
            if (this.job.hasPermission(Item.DELETE)) {
                this.branches.clear();
                this.save();
                result = FormValidation.ok((String)"Branches deleted");
            } else {
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't delete repository file '{}'.", (Object)this.configFile.getFile().getAbsolutePath(), (Object)e);
            result = FormValidation.error((Throwable)e, (String)("Can't delete: " + e.getMessage()));
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRunTrigger() throws IOException {
        FormValidation result;
        try {
            if (this.job.hasPermission(Item.BUILD)) {
                GitHubBranchTrigger trigger = JobHelper.ghBranchTriggerFromJob(this.job);
                if (trigger != null) {
                    trigger.run();
                    result = FormValidation.ok((String)"GitHub Branch trigger run");
                    LOG.debug("GitHub Branch trigger run for {}", (Object)this.job);
                } else {
                    LOG.error("GitHub Branch trigger not available for {}", (Object)this.job);
                    result = FormValidation.error((String)"GitHub Branch trigger not available");
                }
            } else {
                LOG.warn("No permissions to run GitHub Branch trigger");
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't run trigger", (Object)e.getMessage());
            result = FormValidation.error((Throwable)e, (String)"Can't run trigger: %s", (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRebuildAllFailed() throws IOException {
        FormValidation result;
        try {
            if (this.job.hasPermission(Item.BUILD)) {
                Map<String, List<Run<?, ?>>> builds = this.getAllBranchBuilds();
                for (List<Run<?, ?>> buildList : builds.values()) {
                    if (buildList.isEmpty() || !Result.FAILURE.equals(buildList.get(0).getResult())) continue;
                    Run<?, ?> lastBuild = buildList.get(0);
                    org.jenkinsci.plugins.github.pullrequest.utils.JobHelper.rebuild(lastBuild);
                }
                result = FormValidation.ok((String)"Rebuild scheduled");
            } else {
                result = FormValidation.error((String)"Forbidden");
            }
        }
        catch (Exception e) {
            LOG.error("Can't start rebuild", (Object)e.getMessage());
            result = FormValidation.error((Throwable)e, (String)"Can't start rebuild: %s", (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doBuild(StaplerRequest req) throws IOException {
        FormValidation result;
        try {
            if (!this.job.hasPermission(Item.BUILD)) {
                return FormValidation.error((String)"Forbidden");
            }
            String param = "branchName";
            String branchName = null;
            if (req.hasParameter("branchName")) {
                branchName = req.getParameter("branchName");
            }
            if (Objects.isNull(branchName) || !this.getBranches().containsKey(branchName)) {
                return FormValidation.error((String)"No branch to build");
            }
            GitHubBranch localBranch = this.getBranches().get(branchName);
            GitHubBranchCause cause = new GitHubBranchCause(localBranch, this, "Manual run.", false);
            JobRunnerForBranchCause runner = new JobRunnerForBranchCause(this.getJob(), JobHelper.ghBranchTriggerFromJob(this.job));
            QueueTaskFuture<?> queueTaskFuture = runner.startJob(cause);
            result = Objects.nonNull(queueTaskFuture) ? FormValidation.ok((String)"Build scheduled") : FormValidation.warning((String)"Build not scheduled");
        }
        catch (Exception e) {
            LOG.error("Can't start build", (Object)e.getMessage());
            result = FormValidation.error((Throwable)e, (String)("Can't start build: " + e.getMessage()));
        }
        return result;
    }

    @Override
    @RequirePOST
    public FormValidation doRebuild(StaplerRequest req) throws IOException {
        FormValidation result;
        try {
            Map<String, List<Run<?, ?>>> allBuilds;
            List<Run<?, ?>> branchBuilds;
            if (!this.job.hasPermission(Item.BUILD)) {
                return FormValidation.error((String)"Forbidden");
            }
            String param = "branchName";
            String branchName = "";
            if (req.hasParameter("branchName")) {
                branchName = req.getParameter("branchName");
            }
            result = (branchBuilds = (allBuilds = this.getAllBranchBuilds()).get(branchName)) != null && !allBuilds.isEmpty() ? (org.jenkinsci.plugins.github.pullrequest.utils.JobHelper.rebuild(branchBuilds.get(0)) ? FormValidation.ok((String)"Rebuild scheduled") : FormValidation.warning((String)"Rebuild not scheduled")) : FormValidation.warning((String)"Build not found");
        }
        catch (Exception e) {
            LOG.error("Can't start rebuild", (Object)e.getMessage());
            result = FormValidation.error((Throwable)e, (String)("Can't start rebuild: " + e.getMessage()));
        }
        return result;
    }
}

