/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch;

import com.github.kostyasha.github.integration.branch.AbstractGitHubBranchCause;
import com.github.kostyasha.github.integration.branch.GitHubBranch;
import com.github.kostyasha.github.integration.branch.GitHubBranchPollingLogAction;
import com.github.kostyasha.github.integration.branch.GitHubBranchRepository;
import com.github.kostyasha.github.integration.branch.data.GitHubBranchEnv;
import com.github.kostyasha.github.integration.multibranch.head.GitHubBranchSCMHead;
import com.github.kostyasha.github.integration.multibranch.head.GitHubSCMHead;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.io.FileUtils;
import org.kohsuke.github.GHBranch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubBranchCause
extends AbstractGitHubBranchCause<GitHubBranchCause> {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubBranchCause.class);
    private final String branchName;

    public GitHubBranchCause(@NonNull GitHubBranch localBranch, @NonNull GitHubBranchRepository localRepo, String reason, boolean skip) {
        this(localBranch.getName(), localBranch.getCommitSha());
        this.withReason(reason);
        this.withSkip(skip);
        this.withLocalRepo(localRepo);
    }

    public GitHubBranchCause(@NonNull GHBranch remoteBranch, @NonNull GitHubBranchRepository localRepo, String reason, boolean skip) {
        this(remoteBranch.getName(), remoteBranch.getSHA1());
        this.withReason(reason);
        this.withSkip(skip);
        this.withLocalRepo(localRepo);
        this.withRemoteData(remoteBranch);
    }

    public GitHubBranchCause(@NonNull String branchName, String commitSha) {
        super(commitSha, "refs/heads/" + branchName);
        this.branchName = branchName;
    }

    public GitHubBranchCause(GitHubBranchCause cause) {
        super(cause);
        this.branchName = cause.getBranchName();
    }

    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public void fillParameters(List<ParameterValue> params) {
        GitHubBranchEnv.getParams(this, params);
    }

    @Override
    public GitHubSCMHead<GitHubBranchCause> createSCMHead(String sourceId) {
        return new GitHubBranchSCMHead(this.branchName, sourceId);
    }

    @NonNull
    public String getShortDescription() {
        if (this.getHtmlUrl() != null) {
            return "GitHub branch " + this.getBranchName() + ": " + this.getReason();
        }
        return "Deleted branch";
    }

    public void onAddedTo(@NonNull Run run) {
        if (run.getParent().getParent() instanceof SCMSourceOwner) {
            return;
        }
        try {
            GitHubBranchPollingLogAction action = new GitHubBranchPollingLogAction(run);
            FileUtils.writeStringToFile((File)action.getPollingLogFile(), (String)this.getPollingLog());
            run.replaceAction((Action)action);
        }
        catch (IOException ex) {
            LOG.warn("Failed to persist the polling log", (Throwable)ex);
        }
        this.setPollingLog(null);
    }
}

