/*
 * Decompiled with CFR 0.152.
 */
package com.github.kostyasha.github.integration.branch;

import com.github.kostyasha.github.integration.generic.GitHubCause;
import edu.umd.cs.findbugs.annotations.CheckForNull;

public abstract class AbstractGitHubBranchCause<T extends AbstractGitHubBranchCause<T>>
extends GitHubCause<T> {
    @CheckForNull
    private final String commitSha;
    @CheckForNull
    private final String fullRef;

    protected AbstractGitHubBranchCause(String commitSha, String fullRef) {
        this.commitSha = commitSha;
        this.fullRef = fullRef;
    }

    protected AbstractGitHubBranchCause(AbstractGitHubBranchCause<T> cause) {
        this(cause.getCommitSha(), cause.getFullRef());
        this.withGitUrl(cause.getGitUrl());
        this.withSshUrl(cause.getSshUrl());
        this.withHtmlUrl(cause.getHtmlUrl());
        this.withPollingLog(cause.getPollingLog());
        this.withReason(cause.getReason());
        this.withSkip(cause.isSkip());
        this.withTitle(cause.getTitle());
    }

    @CheckForNull
    public String getCommitSha() {
        return this.commitSha;
    }

    @CheckForNull
    public String getFullRef() {
        return this.fullRef;
    }
}

