/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.tasks.Mailer;
import hudson.util.Secret;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.GitHubOAuthScope;
import org.jenkinsci.plugins.GithubAuthenticationToken;
import org.jenkinsci.plugins.GithubOAuthGroupDetails;
import org.jenkinsci.plugins.GithubOAuthUserDetails;
import org.jenkinsci.plugins.GithubSecretStorage;
import org.kohsuke.github.GHEmail;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GithubSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final String DEFAULT_WEB_URI = "https://github.com";
    private static final String DEFAULT_API_URI = "https://api.github.com";
    private static final String DEFAULT_ENTERPRISE_API_SUFFIX = "/api/v3";
    private static final String DEFAULT_OAUTH_SCOPES = "read:org,user:email,repo";
    private String githubWebUri;
    private String githubApiUri;
    private String clientID;
    private Secret clientSecret;
    private String oauthScopes;
    private String[] myScopes;
    private static final Logger LOGGER = Logger.getLogger(GithubSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = GithubSecurityRealm.class.getName() + ".referer";
    private static final String STATE_ATTRIBUTE = "state";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    @DataBoundConstructor
    public GithubSecurityRealm(String githubWebUri, String githubApiUri, String clientID, String clientSecret, String oauthScopes) {
        this.githubWebUri = Util.fixEmptyAndTrim((String)githubWebUri);
        this.githubApiUri = Util.fixEmptyAndTrim((String)githubApiUri);
        this.clientID = Util.fixEmptyAndTrim((String)clientID);
        this.setClientSecret(Util.fixEmptyAndTrim((String)clientSecret));
        this.oauthScopes = Util.fixEmptyAndTrim((String)oauthScopes);
    }

    private GithubSecurityRealm() {
    }

    private String determineApiUri(String githubWebUri) {
        if (githubWebUri.equals(DEFAULT_WEB_URI)) {
            return DEFAULT_API_URI;
        }
        return githubWebUri + DEFAULT_ENTERPRISE_API_SUFFIX;
    }

    private void setGithubWebUri(String githubWebUri) {
        this.githubWebUri = githubWebUri;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    private void setClientSecret(String clientSecret) {
        this.clientSecret = Secret.fromString((String)clientSecret);
    }

    private void setOauthScopes(String oauthScopes) {
        this.oauthScopes = oauthScopes;
    }

    public boolean hasScope(String scope) {
        if (this.myScopes == null) {
            this.myScopes = this.oauthScopes.split(",");
            Arrays.sort(this.myScopes);
        }
        return Arrays.binarySearch(this.myScopes, scope) >= 0;
    }

    public String getGithubApiUri() {
        return this.githubApiUri;
    }

    private void setGithubApiUri(String githubApiUri) {
        this.githubApiUri = githubApiUri;
    }

    public String getGithubWebUri() {
        return this.githubWebUri;
    }

    @Deprecated
    public String getGithubUri() {
        return this.getGithubWebUri();
    }

    public String getClientID() {
        return this.clientID;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getOauthScopes() {
        return this.oauthScopes;
    }

    public HttpResponse doCommenceLogin(StaplerRequest2 request, @QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        String state = this.getSecureRandomString(27);
        String redirectOnFinish = from != null && Util.isSafeToRedirectTo((String)from) ? from : (referer != null && (referer.startsWith(Jenkins.get().getRootUrl()) || Util.isSafeToRedirectTo((String)referer)) ? referer : Jenkins.get().getRootUrl());
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)redirectOnFinish);
        request.getSession().setAttribute(STATE_ATTRIBUTE, (Object)state);
        HashSet<String> scopes = new HashSet<String>();
        for (GitHubOAuthScope s : Jenkins.get().getExtensionList(GitHubOAuthScope.class)) {
            scopes.addAll(s.getScopesToRequest());
        }
        Object suffix = "";
        suffix = !scopes.isEmpty() ? "&scope=" + String.join((CharSequence)",", scopes) + "&state=" + state : "&scope=" + this.oauthScopes + "&state=" + state;
        return new HttpRedirect(this.githubWebUri + "/login/oauth/authorize?client_id=" + this.clientID + (String)suffix);
    }

    public HttpResponse doFinishLogin(StaplerRequest2 request) throws IOException {
        String code = request.getParameter("code");
        String state = request.getParameter(STATE_ATTRIBUTE);
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        String expectedState = (String)request.getSession().getAttribute(STATE_ATTRIBUTE);
        if (code == null || code.trim().length() == 0) {
            LOGGER.info("doFinishLogin: missing code.");
            return HttpResponses.redirectToContextRoot();
        }
        if (state == null) {
            LOGGER.info("doFinishLogin: missing state parameter from Github response.");
            return HttpResponses.redirectToContextRoot();
        }
        if (expectedState == null) {
            LOGGER.info("doFinishLogin: missing state parameter from user's session.");
            return HttpResponses.redirectToContextRoot();
        }
        if (!state.equals(expectedState)) {
            LOGGER.info("state parameter value [" + state + "] does not match the expected one [" + expectedState + "]");
            return HttpResponses.redirectToContextRoot();
        }
        String accessToken = this.getAccessToken(code);
        if (accessToken != null && accessToken.trim().length() > 0) {
            GithubAuthenticationToken auth = new GithubAuthenticationToken(accessToken, this.getGithubApiUri(), true);
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            request.getSession(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            GHMyself self = auth.getMyself();
            User u = User.current();
            if (u == null) {
                throw new IllegalStateException("Can't find user");
            }
            GithubSecretStorage.put(u, accessToken);
            u.setFullName(self.getName());
            if (!((Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)).hasExplicitlyConfiguredAddress()) {
                if (this.hasScope("user") || this.hasScope("user:email")) {
                    String primary_email = null;
                    for (GHEmail e : self.getEmails2()) {
                        if (!e.isPrimary()) continue;
                        primary_email = e.getEmail();
                    }
                    if (primary_email != null) {
                        u.addProperty((UserProperty)new Mailer.UserProperty(primary_email));
                    }
                } else {
                    u.addProperty((UserProperty)new Mailer.UserProperty(auth.getGitHub().getMyself().getEmail()));
                }
            }
            SecurityListener.fireAuthenticated2((UserDetails)new GithubOAuthUserDetails(self.getLogin(), auth.getAuthorities()));
        } else {
            LOGGER.info("Github did not return an access token.");
        }
        if (referer != null) {
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    @Nullable
    private String getAccessToken(@NonNull String code) throws IOException {
        String[] parts;
        String content;
        HttpPost httpost = new HttpPost(this.githubWebUri + "/login/oauth/access_token?client_id=" + this.clientID + "&client_secret=" + this.clientSecret.getPlainText() + "&code=" + code);
        try (CloseableHttpClient httpClient = this.configureClientWithProxy(httpost);){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpost);
            HttpEntity entity = response.getEntity();
            content = EntityUtils.toString((HttpEntity)entity);
        }
        for (String part : parts = content.split("&")) {
            if (!part.startsWith("access_token=")) continue;
            String[] tokenParts = part.split("=");
            return tokenParts[1];
        }
        return null;
    }

    private CloseableHttpClient configureClientWithProxy(HttpPost postLocation) {
        ProxyConfiguration proxyConfiguration = Jenkins.get().proxy;
        if (proxyConfiguration == null) {
            return HttpClients.createDefault();
        }
        HttpHost proxyHost = this.getProxy(proxyConfiguration, postLocation.getURI().getHost());
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (proxyHost != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(proxyHost).build();
            postLocation.setConfig(requestConfig);
            if (proxyConfiguration.getUserName() != null && proxyConfiguration.getSecretPassword() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUserName(), proxyConfiguration.getSecretPassword().getPlainText()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        return httpClientBuilder.build();
    }

    private String getSecureRandomString(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length must be a positive integer");
        }
        String urlSafeChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_".charAt(SECURE_RANDOM.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_".length())));
        }
        return sb.toString();
    }

    private HttpHost getProxy(ProxyConfiguration proxy, String host) {
        Proxy p = proxy.createProxy(host);
        switch (p.type()) {
            case DIRECT: {
                return null;
            }
            case HTTP: {
                InetSocketAddress sa = (InetSocketAddress)p.address();
                return new HttpHost(sa.getHostName(), sa.getPort());
            }
        }
        return null;
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof GithubAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken) {
                    try {
                        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
                        GithubAuthenticationToken github = new GithubAuthenticationToken(token.getCredentials().toString(), GithubSecurityRealm.this.getGithubApiUri());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)github);
                        User user = User.getById((String)token.getName(), (boolean)false);
                        if (user != null) {
                            GithubSecretStorage.put(user, token.getCredentials().toString());
                        }
                        SecurityListener.fireAuthenticated2((UserDetails)new GithubOAuthUserDetails(token.getName(), github.getAuthorities()));
                        return github;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
            }
        }, this::loadUserByUsername2);
    }

    protected GithubOAuthUserDetails authenticate2(String username, String password) throws AuthenticationException {
        try {
            GithubAuthenticationToken github = new GithubAuthenticationToken(password, this.getGithubApiUri());
            if (username.equals(github.getPrincipal())) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)github);
                return github.getUserDetails(username);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new BadCredentialsException("Invalid GitHub username or personal access token: " + username);
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    protected String getPostLogOutUrl2(StaplerRequest2 req, Authentication auth) {
        Jenkins j = Jenkins.get();
        if (j.hasPermission(Jenkins.READ)) {
            return super.getPostLogOutUrl2(req, auth);
        }
        return req.getContextPath() + "/githubLogout";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
        if (username.contains("*")) {
            throw new UsernameNotFoundException("Using org*team format instead of username: " + username);
        }
        User localUser = User.getById((String)username, (boolean)false);
        Object token = SecurityContextHolder.getContext().getAuthentication();
        try {
            if (localUser != null && GithubSecretStorage.contains(localUser)) {
                String accessToken = GithubSecretStorage.retrieve(localUser);
                token = new GithubAuthenticationToken(accessToken, this.getGithubApiUri());
            }
        }
        catch (IOException | UsernameNotFoundException e) {
            if (e instanceof IOException) {
                throw new UserMayOrMayNotExistException2("Could not connect to GitHub API server, target URL = " + this.getGithubApiUri(), e);
            }
            LOGGER.log(Level.FINE, "Attempted to impersonate " + username + " but token in user property was invalid.");
        }
        if (!(token instanceof GithubAuthenticationToken)) {
            throw new UserMayOrMayNotExistException2("Unexpected authentication type: " + String.valueOf(token));
        }
        GithubAuthenticationToken authToken = (GithubAuthenticationToken)((Object)token);
        if (localUser != null) {
            GHUser user;
            try {
                user = authToken.loadUser(username);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Collection<Object> authorities = user != null ? authToken.getAuthorities() : List.of();
            return new GithubOAuthUserDetails(username, authorities);
        }
        try {
            GithubOAuthUserDetails userDetails = authToken.getUserDetails(username);
            if (userDetails == null) {
                throw new UsernameNotFoundException("Unknown user: " + username);
            }
            GHOrganization ghOrg = authToken.loadOrganization(username);
            if (ghOrg != null) {
                throw new UsernameNotFoundException("user(" + username + ") is also an organization");
            }
            return userDetails;
        }
        catch (IOException | Error e) {
            throw new AuthenticationServiceException("loadUserByUsername (username=" + username + ")", e);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GithubSecurityRealm) {
            GithubSecurityRealm obj = (GithubSecurityRealm)((Object)object);
            return this.getGithubWebUri().equals(obj.getGithubWebUri()) && this.getGithubApiUri().equals(obj.getGithubApiUri()) && this.getClientID().equals(obj.getClientID()) && this.getClientSecret().equals((Object)obj.getClientSecret()) && this.getOauthScopes().equals(obj.getOauthScopes());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGithubWebUri()).append((Object)this.getGithubApiUri()).append((Object)this.getClientID()).append((Object)this.getClientSecret()).append((Object)this.getOauthScopes()).toHashCode();
    }

    public GroupDetails loadGroupByGroupname2(String groupName, boolean fetchMembers) throws UsernameNotFoundException {
        GithubAuthenticationToken authToken = (GithubAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        if (authToken == null) {
            throw new UsernameNotFoundException("No known group: " + groupName);
        }
        try {
            int idx = groupName.indexOf("*");
            if (idx > -1 && groupName.length() > idx + 1) {
                String orgName = groupName.substring(0, idx);
                String teamName = groupName.substring(idx + 1);
                LOGGER.config(String.format("Lookup for team %s in organization %s", teamName, orgName));
                GHTeam ghTeam = authToken.loadTeam(orgName, teamName);
                if (ghTeam == null) {
                    throw new UsernameNotFoundException("Unknown GitHub team: " + teamName + " in organization " + orgName);
                }
                return new GithubOAuthGroupDetails(ghTeam);
            }
            GHOrganization ghOrg = authToken.loadOrganization(groupName);
            if (ghOrg == null) {
                throw new UsernameNotFoundException("Unknown GitHub organization: " + groupName);
            }
            return new GithubOAuthGroupDetails(ghOrg);
        }
        catch (Error e) {
            throw new AuthenticationServiceException("loadGroupByGroupname (groupname=" + groupName + ")", (Throwable)e);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/github-oauth/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "Github Authentication Plugin";
        }

        public String getDefaultGithubWebUri() {
            return GithubSecurityRealm.DEFAULT_WEB_URI;
        }

        public String getDefaultGithubApiUri() {
            return GithubSecurityRealm.DEFAULT_API_URI;
        }

        public String getDefaultOauthScopes() {
            return GithubSecurityRealm.DEFAULT_OAUTH_SCOPES;
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == GithubSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GithubSecurityRealm realm = (GithubSecurityRealm)((Object)source);
            writer.startNode("githubWebUri");
            writer.setValue(realm.getGithubWebUri());
            writer.endNode();
            writer.startNode("githubApiUri");
            writer.setValue(realm.getGithubApiUri());
            writer.endNode();
            writer.startNode("clientID");
            writer.setValue(realm.getClientID());
            writer.endNode();
            writer.startNode("clientSecret");
            writer.setValue(realm.getClientSecret().getEncryptedValue());
            writer.endNode();
            writer.startNode("oauthScopes");
            writer.setValue(realm.getOauthScopes());
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            GithubSecurityRealm realm = new GithubSecurityRealm();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String node = reader.getNodeName();
                String value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            if (realm.getGithubWebUri() == null) {
                realm.setGithubWebUri(GithubSecurityRealm.DEFAULT_WEB_URI);
            }
            if (realm.getGithubApiUri() == null) {
                realm.setGithubApiUri(GithubSecurityRealm.DEFAULT_API_URI);
            }
            return realm;
        }

        private void setValue(GithubSecurityRealm realm, String node, String value) {
            if (node.equalsIgnoreCase("clientid")) {
                realm.setClientID(value);
            } else if (node.equalsIgnoreCase("clientsecret")) {
                realm.setClientSecret(value);
            } else if (node.equalsIgnoreCase("githubweburi")) {
                realm.setGithubWebUri(value);
            } else if (node.equalsIgnoreCase("githuburi")) {
                realm.setGithubWebUri(value);
                String apiUrl = realm.determineApiUri(value);
                realm.setGithubApiUri(apiUrl);
            } else if (node.equalsIgnoreCase("githubapiuri")) {
                realm.setGithubApiUri(value);
            } else if (node.equalsIgnoreCase("oauthscopes")) {
                realm.setOauthScopes(value);
            } else {
                throw new ConversionException("Invalid node value = " + node);
            }
        }
    }
}

