/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.Permission;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.GitHubRepositoryName;
import org.jenkinsci.plugins.GithubAuthenticationToken;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class GithubRequireOrganizationMembershipACL
extends ACL {
    private static final Logger log = Logger.getLogger(GithubRequireOrganizationMembershipACL.class.getName());
    private final List<String> organizationNameList;
    private final List<String> adminUserNameList;
    private String agentUserName;
    private final boolean authenticatedUserReadPermission;
    private final boolean useRepositoryPermissions;
    private final boolean authenticatedUserCreateJobPermission;
    private final boolean allowGithubWebHookPermission;
    private final boolean allowCcTrayPermission;
    private final boolean allowAnonymousReadPermission;
    private final boolean allowAnonymousJobStatusPermission;
    private final AbstractItem item;

    public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
        if (a instanceof GithubAuthenticationToken) {
            if (!a.isAuthenticated()) {
                return false;
            }
            GithubAuthenticationToken authenticationToken = (GithubAuthenticationToken)a;
            String candidateName = a.getName();
            if (this.adminUserNameList.contains(candidateName)) {
                log.finest("Granting Admin rights to user " + candidateName);
                return true;
            }
            if (this.authenticatedUserCreateJobPermission && permission.equals((Object)Item.CREATE)) {
                return true;
            }
            if (candidateName.equalsIgnoreCase(this.agentUserName) && this.checkAgentUserPermission(permission)) {
                log.finest("Granting Agent Connect rights to user " + candidateName);
                return true;
            }
            if (this.checkReadPermission(permission)) {
                if (this.authenticatedUserReadPermission) {
                    log.finest("Granting Authenticated User read permission to user " + candidateName);
                    return true;
                }
                if (this.isInWhitelistedOrgs(authenticationToken)) {
                    log.finest("Granting READ rights to user " + candidateName + " as a member of whitelisted organization");
                    return true;
                }
            } else if (this.testBuildPermission(permission) && this.isInWhitelistedOrgs(authenticationToken)) {
                log.finest("Granting BUILD rights to user " + candidateName + " as a member of whitelisted organization");
                return true;
            }
            if (this.useRepositoryPermissions && this.item != null) {
                String repositoryName = this.getRepositoryName();
                if (repositoryName == null) {
                    return false;
                }
                return authenticationToken.hasRepositoryPermission(repositoryName, permission);
            }
            return false;
        }
        String authenticatedUserName = a.getName();
        if (authenticatedUserName == null) {
            throw new IllegalArgumentException("Authentication must have a valid name");
        }
        if (authenticatedUserName.equals(SYSTEM2.getPrincipal())) {
            log.finest("Granting Full rights to SYSTEM user.");
            return true;
        }
        if (authenticatedUserName.equalsIgnoreCase(this.agentUserName) && this.checkAgentUserPermission(permission)) {
            log.finest("Granting Agent Connect rights to user " + authenticatedUserName);
            return true;
        }
        if (authenticatedUserName.equals("anonymous")) {
            if (this.checkJobStatusPermission(permission) && this.allowAnonymousJobStatusPermission) {
                return true;
            }
            if (this.checkReadPermission(permission)) {
                if (this.allowAnonymousReadPermission) {
                    return true;
                }
                if (this.allowGithubWebHookPermission && (this.currentUriPathEquals("github-webhook") || this.currentUriPathEquals("github-webhook/"))) {
                    log.finest("Granting READ access for github-webhook url: " + this.requestURI());
                    return true;
                }
                if (this.allowCcTrayPermission && this.currentUriPathEndsWithSegment("cc.xml")) {
                    log.finest("Granting READ access for cctray url: " + this.requestURI());
                    return true;
                }
                log.finer("Denying anonymous READ permission to url: " + this.requestURI());
            }
            return false;
        }
        if (this.adminUserNameList.contains(authenticatedUserName)) {
            log.finest("Granting Admin rights to user " + a.getName());
            return true;
        }
        return false;
    }

    @NonNull
    private boolean isInWhitelistedOrgs(@NonNull GithubAuthenticationToken authenticationToken) {
        return authenticationToken.isMemberOfAnyOrganizationInList(this.organizationNameList);
    }

    private boolean currentUriPathEquals(String specificPath) {
        Jenkins jenkins = Jenkins.get();
        String rootUrl = jenkins.getRootUrl();
        if (rootUrl == null) {
            throw new IllegalStateException("Could not determine Jenkins URL");
        }
        String requestUri = this.requestURI();
        if (requestUri != null) {
            String basePath = URI.create(rootUrl).getPath();
            return URI.create(requestUri).getPath().equals(basePath + specificPath);
        }
        return false;
    }

    private boolean currentUriPathEndsWithSegment(String segment) {
        String requestUri = this.requestURI();
        if (requestUri != null) {
            return requestUri.substring(requestUri.lastIndexOf(47) + 1).equals(segment);
        }
        return false;
    }

    @Nullable
    private String requestURI() {
        StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
        return currentRequest == null ? null : currentRequest.getOriginalRequestURI();
    }

    private boolean testBuildPermission(@NonNull Permission permission) {
        String id = permission.getId();
        return id.equals("hudson.model.Hudson.Build") || id.equals("hudson.model.Item.Build");
    }

    private boolean checkReadPermission(@NonNull Permission permission) {
        String id = permission.getId();
        return id.equals("hudson.model.Hudson.Read") || id.equals("hudson.model.Item.Workspace") || id.equals("hudson.model.Item.Discover") || id.equals("hudson.model.Item.Read");
    }

    private boolean checkAgentUserPermission(@NonNull Permission permission) {
        return permission.equals((Object)Hudson.READ) || permission.equals((Object)Computer.CREATE) || permission.equals((Object)Computer.CONNECT) || permission.equals((Object)Computer.CONFIGURE);
    }

    private boolean checkJobStatusPermission(@NonNull Permission permission) {
        return permission.getId().equals("hudson.model.Item.ViewStatus");
    }

    @Nullable
    private String getRepositoryName() {
        GitHubRepositoryName githubRepositoryName;
        List userRemoteConfigs;
        GitHubSCMSource git;
        String repositoryName = null;
        String repoUrl = null;
        SCM scm = null;
        if (this.item instanceof WorkflowJob) {
            project = (WorkflowJob)this.item;
            scm = ((BranchJobProperty)project.getProperty(BranchJobProperty.class)).getBranch().getScm();
        } else if (this.item instanceof MultiBranchProject) {
            project = (MultiBranchProject)this.item;
            scm = (SCMSource)project.getSCMSources().get(0);
        } else if (this.item instanceof AbstractProject) {
            project = (AbstractProject)this.item;
            scm = project.getScm();
        }
        if (scm instanceof GitHubSCMSource) {
            git = (GitHubSCMSource)scm;
            repoUrl = git.getRemote();
        } else if (scm instanceof GitSCM && !(userRemoteConfigs = (git = (GitSCM)scm).getUserRemoteConfigs()).isEmpty()) {
            repoUrl = ((UserRemoteConfig)userRemoteConfigs.get(0)).getUrl();
        }
        if (repoUrl != null && (githubRepositoryName = GitHubRepositoryName.create(repoUrl)) != null) {
            repositoryName = githubRepositoryName.userName + "/" + githubRepositoryName.repositoryName;
        }
        return repositoryName;
    }

    public GithubRequireOrganizationMembershipACL(String adminUserNames, String organizationNames, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGithubWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission) {
        String[] parts;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGithubWebHookPermission = allowGithubWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.adminUserNameList = new LinkedList<String>();
        for (String part : parts = adminUserNames.split(",")) {
            this.adminUserNameList.add(part.trim());
        }
        this.organizationNameList = new LinkedList<String>();
        for (String part : parts = organizationNames.split(",")) {
            this.organizationNameList.add(part.trim());
        }
        this.item = null;
        this.agentUserName = "";
    }

    public GithubRequireOrganizationMembershipACL cloneForProject(AbstractItem item) {
        GithubRequireOrganizationMembershipACL acl = new GithubRequireOrganizationMembershipACL(this.adminUserNameList, this.organizationNameList, this.authenticatedUserReadPermission, this.useRepositoryPermissions, this.authenticatedUserCreateJobPermission, this.allowGithubWebHookPermission, this.allowCcTrayPermission, this.allowAnonymousReadPermission, this.allowAnonymousJobStatusPermission, item);
        acl.setAgentUserName(this.agentUserName);
        return acl;
    }

    public GithubRequireOrganizationMembershipACL(List<String> adminUserNameList, List<String> organizationNameList, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGithubWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission, AbstractItem item) {
        this.adminUserNameList = adminUserNameList;
        this.organizationNameList = organizationNameList;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGithubWebHookPermission = allowGithubWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.item = item;
    }

    public List<String> getOrganizationNameList() {
        return this.organizationNameList;
    }

    public List<String> getAdminUserNameList() {
        return this.adminUserNameList;
    }

    public void setAgentUserName(String agentUserName) {
        this.agentUserName = agentUserName;
    }

    public String getAgentUserName() {
        return this.agentUserName;
    }

    public boolean isUseRepositoryPermissions() {
        return this.useRepositoryPermissions;
    }

    public boolean isAuthenticatedUserCreateJobPermission() {
        return this.authenticatedUserCreateJobPermission;
    }

    public boolean isAuthenticatedUserReadPermission() {
        return this.authenticatedUserReadPermission;
    }

    public boolean isAllowGithubWebHookPermission() {
        return this.allowGithubWebHookPermission;
    }

    public boolean isAllowCcTrayPermission() {
        return this.allowCcTrayPermission;
    }

    public boolean isAllowAnonymousReadPermission() {
        return this.allowAnonymousReadPermission;
    }

    public boolean isAllowAnonymousJobStatusPermission() {
        return this.allowAnonymousJobStatusPermission;
    }
}

