/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source.app_credentials;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AccessibleRepositories {
    private final String owner;
    private final List<String> repositories;

    public AccessibleRepositories(@CheckForNull String owner, @NonNull List<String> repositories) {
        this.owner = owner;
        this.repositories = new ArrayList<String>(repositories);
    }

    public AccessibleRepositories(@CheckForNull String owner) {
        this(owner, Collections.emptyList());
    }

    public AccessibleRepositories(@CheckForNull String owner, @NonNull String repository) {
        this(owner, Collections.singletonList(repository));
    }

    @CheckForNull
    public String getOwner() {
        return this.owner;
    }

    @NonNull
    public List<String> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.repositories);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibleRepositories other = (AccessibleRepositories)obj;
        return Objects.equals(this.owner, other.owner) && Objects.equals(this.repositories, other.repositories);
    }

    public String toString() {
        return this.owner + "/" + String.valueOf(this.repositories);
    }
}

