/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.core.Authentication;

public class SSHCheckoutTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public SSHCheckoutTrait(@CheckForNull String credentialsId) {
        this.credentialsId = "ANONYMOUS".equals(credentialsId) ? null : Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitHubSCMBuilder)((GitHubSCMBuilder)builder).withCredentials(this.credentialsId)).withResolver(GitHubSCMBuilder.SSH);
    }

    @Symbol(value={"gitHubSshCheckout"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHCheckoutTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitHubSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitHubSCMSource.class;
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            StandardListBoxModel result = new StandardListBoxModel();
            result.add(Messages.SSHCheckoutTrait_useAgentKey(), "");
            return result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, Connector.githubDomainRequirements(apiUri), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class));
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String value) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(SSHUserPrivateKey.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication2() : ACL.SYSTEM2), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication2() : ACL.SYSTEM2), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.error((String)Messages.SSHCheckoutTrait_incompatibleCredentials());
            }
            return FormValidation.warning((String)Messages.SSHCheckoutTrait_missingCredentials());
        }
    }
}

