/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.details.Detail;
import jenkins.model.details.DetailFactory;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubBranchDetail;
import org.jenkinsci.plugins.github_branch_source.GitHubCommitDetail;
import org.jenkinsci.plugins.github_branch_source.GitHubPullRequestDetail;
import org.jenkinsci.plugins.github_branch_source.GitHubRepositoryDetail;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;

@Extension
public final class GitHubDetailFactory
extends DetailFactory<Run> {
    public Class<Run> type() {
        return Run.class;
    }

    @NonNull
    public List<? extends Detail> createFor(@NonNull Run target) {
        SCMSource src = SCMSource.SourceByItem.findSource((Item)target.getParent());
        if (!(src instanceof GitHubSCMSource)) {
            return Collections.emptyList();
        }
        SCMRevisionAction scmRevisionAction = (SCMRevisionAction)target.getAction(SCMRevisionAction.class);
        if (scmRevisionAction == null) {
            return Collections.emptyList();
        }
        ArrayList<Detail> details = new ArrayList<Detail>();
        SCMRevision revision = scmRevisionAction.getRevision();
        if (revision instanceof PullRequestSCMRevision) {
            details.add(new GitHubPullRequestDetail((Actionable)target));
        } else {
            details.add(new GitHubBranchDetail((Actionable)target));
        }
        details.add(new GitHubCommitDetail((Actionable)target));
        details.add(new GitHubRepositoryDetail((Actionable)target));
        return details;
    }
}

