/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.coravy.hudson.plugins.github.GithubProjectProperty;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMSource;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.JenkinsJVM;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubAppUsageContext;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.app_credentials.AccessSpecifiedRepositories;
import org.jenkinsci.plugins.github_branch_source.app_credentials.AccessibleRepositories;
import org.jenkinsci.plugins.github_branch_source.app_credentials.DefaultPermissionsStrategy;
import org.jenkinsci.plugins.github_branch_source.app_credentials.MigrationAdminMonitor;
import org.jenkinsci.plugins.github_branch_source.app_credentials.RepositoryAccessStrategy;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHAppCreateTokenBuilder;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.authorization.AuthorizationProvider;
import org.kohsuke.github.extras.authorization.JWTTokenProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="XStream")
public class GitHubAppCredentials
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    private static final Logger LOGGER = Logger.getLogger(GitHubAppCredentials.class.getName());
    private static final String ERROR_AUTHENTICATING_GITHUB_APP = "Couldn't authenticate with GitHub app ID %s";
    private static final String NOT_INSTALLED = ", has it been installed to your GitHub organisation / user?";
    private static final String ERROR_NOT_INSTALLED = "Couldn't authenticate with GitHub app ID %s, has it been installed to your GitHub organisation / user?";
    private static final String ERROR_NO_OWNER_MATCHING = "Found multiple installations for GitHub app ID %s but none match credential owner \"%s\". Configure the repository access strategy for the credential to use one of these owners: %s";
    private static long AFTER_TOKEN_GENERATION_DELAY_SECONDS = Long.getLong(GitHubAppCredentials.class.getName() + ".AFTER_TOKEN_GENERATION_DELAY_SECONDS", 0L);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non-final for modification from script console")
    public static boolean ALLOW_UNSAFE_REPOSITORY_INFERENCE = Boolean.getBoolean(GitHubAppCredentials.class.getName() + ".ALLOW_UNSAFE_REPOSITORY_INFERENCE");
    @NonNull
    private final String appID;
    @NonNull
    private final Secret privateKey;
    private String apiUri;
    @Deprecated
    private String owner;
    private RepositoryAccessStrategy repositoryAccessStrategy;
    private DefaultPermissionsStrategy defaultPermissionsStrategy;
    @NonNull
    private transient GitHubAppUsageContext context = new GitHubAppUsageContext();
    private transient AppInstallationToken cachedToken;
    private transient Map<GitHubAppUsageContext, GitHubAppCredentials> cachedCredentials = new ConcurrentHashMap<GitHubAppUsageContext, GitHubAppCredentials>();

    @DataBoundConstructor
    public GitHubAppCredentials(CredentialsScope scope, String id, @CheckForNull String description, @NonNull String appID, @NonNull Secret privateKey) {
        super(scope, id, description);
        this.appID = appID;
        this.privateKey = privateKey;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    @DataBoundSetter
    public void setApiUri(String apiUri) {
        this.apiUri = apiUri;
    }

    @NonNull
    public String getAppID() {
        return this.appID;
    }

    @NonNull
    public Secret getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    @CheckForNull
    public String getOwner() {
        return null;
    }

    public void setOwner(String owner) {
        owner = Util.fixEmptyAndTrim((String)owner);
        LOGGER.log(Level.FINE, null, new Exception("setOwner method called with owner: " + owner));
        this.setRepositoryAccessStrategy(new AccessSpecifiedRepositories(owner, List.of()));
        MigrationAdminMonitor.addMigratedCredentialId(this.getId());
    }

    @NonNull
    public RepositoryAccessStrategy getRepositoryAccessStrategy() {
        return this.repositoryAccessStrategy == null ? new AccessSpecifiedRepositories(this.owner, List.of()) : this.repositoryAccessStrategy;
    }

    @DataBoundSetter
    public void setRepositoryAccessStrategy(@NonNull RepositoryAccessStrategy strategy) {
        this.repositoryAccessStrategy = strategy;
    }

    @NonNull
    public DefaultPermissionsStrategy getDefaultPermissionsStrategy() {
        return this.defaultPermissionsStrategy == null ? DefaultPermissionsStrategy.INHERIT_ALL : this.defaultPermissionsStrategy;
    }

    @DataBoundSetter
    public void setDefaultPermissionsStrategy(@NonNull DefaultPermissionsStrategy strategy) {
        this.defaultPermissionsStrategy = strategy;
    }

    AccessibleRepositories getAccessibleRepositories() {
        return this.getRepositoryAccessStrategy().forContext(this.context);
    }

    Map<String, GHPermissionType> getPermissions() {
        if (this.context.getPermissions() != null) {
            return this.context.getPermissions();
        }
        return this.getDefaultPermissionsStrategy().getPermissions();
    }

    private GitHubAppUsageContext getContext() {
        return this.context;
    }

    AuthorizationProvider getAuthorizationProvider() {
        return new CredentialsTokenProvider(this);
    }

    private static AuthorizationProvider createJwtProvider(String appId, String appPrivateKey) {
        try {
            return new JWTTokenProvider(appId, appPrivateKey);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Couldn't parse private key for GitHub app, make sure it's PKCS#8 format", e);
        }
    }

    static AppInstallationToken generateAppInstallationToken(GitHub gitHubApp, String appId, String appPrivateKey, String apiUrl, String owner, List<String> repositories, Map<String, GHPermissionType> permissions, String inferredOwner) {
        AppInstallationToken appInstallationToken;
        block19: {
            JenkinsJVM.checkJenkinsJVM();
            Timeout ignored = Timeout.limit((long)30L, (TimeUnit)TimeUnit.SECONDS);
            try {
                GHAppInstallation appInstallation;
                GHApp app;
                if (gitHubApp == null) {
                    gitHubApp = TokenProvider.createTokenRefreshGitHub(appId, appPrivateKey, apiUrl);
                }
                try {
                    app = gitHubApp.getApp();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format(ERROR_AUTHENTICATING_GITHUB_APP, appId), e);
                }
                List appInstallations = app.listInstallations().asList();
                if (appInstallations.isEmpty()) {
                    throw new IllegalArgumentException(String.format(ERROR_NOT_INSTALLED, appId));
                }
                String ownerOrNull = Util.fixEmpty((String)owner);
                if (ownerOrNull == null && appInstallations.size() == 1) {
                    appInstallation = (GHAppInstallation)appInstallations.get(0);
                } else {
                    String ownerOrEmpty = Util.fixNull((String)Optional.ofNullable(ownerOrNull).orElse(inferredOwner));
                    Optional<GHAppInstallation> appInstallationOptional = appInstallations.stream().filter(installation -> installation.getAccount().getLogin().toLowerCase(Locale.ROOT).equals(ownerOrEmpty.toLowerCase(Locale.ROOT))).findAny();
                    if (appInstallationOptional.isEmpty()) {
                        String logins = appInstallations.stream().map(installation -> installation.getAccount().getLogin()).collect(Collectors.joining(", "));
                        throw new IllegalArgumentException(String.format(ERROR_NO_OWNER_MATCHING, appId, ownerOrEmpty, logins));
                    }
                    appInstallation = appInstallationOptional.get();
                }
                GHAppCreateTokenBuilder builder = appInstallation.createToken();
                if (!repositories.isEmpty()) {
                    builder.repositories(repositories);
                }
                if (!permissions.isEmpty()) {
                    builder.permissions(permissions);
                } else {
                    builder.permissions(appInstallation.getPermissions());
                }
                GHAppInstallationToken appInstallationToken2 = builder.create();
                long expiration = GitHubAppCredentials.getExpirationSeconds(appInstallationToken2);
                AppInstallationToken token = new AppInstallationToken(Secret.fromString((String)appInstallationToken2.getToken()), expiration);
                LOGGER.log(Level.FINEST, "Generated App Installation Token for app ID {0} limited to {1}/{2} with permissions {3} at {4}", new Object[]{appId, owner, repositories, permissions, Instant.now()});
                if (AFTER_TOKEN_GENERATION_DELAY_SECONDS > 0L) {
                    long tokenDelay = Math.min(10L, AFTER_TOKEN_GENERATION_DELAY_SECONDS);
                    LOGGER.log(Level.FINER, "Waiting {0} seconds after token generation", tokenDelay);
                    Thread.sleep(Duration.ofSeconds(tokenDelay).toMillis());
                }
                appInstallationToken = token;
                if (ignored == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException e) {
                    throw new IllegalArgumentException("Failed to generate GitHub App installation token for app ID " + appId, e);
                }
            }
            ignored.close();
        }
        return appInstallationToken;
    }

    private static long getExpirationSeconds(GHAppInstallationToken appInstallationToken) {
        try {
            return appInstallationToken.getExpiresAt().toInstant().getEpochSecond();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to get GitHub App installation token expiration", e);
            return Instant.now().getEpochSecond() + AppInstallationToken.NOT_STALE_MINIMUM_SECONDS;
        }
    }

    @NonNull
    String actualApiUri() {
        return Util.fixEmpty((String)this.getApiUri()) == null ? "https://api.github.com" : this.getApiUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppInstallationToken getToken(GitHub gitHub) {
        GitHubAppCredentials gitHubAppCredentials = this;
        synchronized (gitHubAppCredentials) {
            try {
                if (this.cachedToken == null || this.cachedToken.isStale()) {
                    LOGGER.log(Level.FINE, "Generating App Installation Token for app ID {0}", this.getAppID());
                    AccessibleRepositories accessibleRepositories = this.getAccessibleRepositories();
                    if (accessibleRepositories == null) {
                        throw new InferredAccessibleRepositoriesException(this);
                    }
                    this.cachedToken = GitHubAppCredentials.generateAppInstallationToken(gitHub, this.getAppID(), this.getPrivateKey().getPlainText(), this.actualApiUri(), accessibleRepositories.getOwner(), accessibleRepositories.getRepositories(), this.getPermissions(), this.getContext().getInferredOwner());
                    LOGGER.log(Level.FINER, "Retrieved GitHub App Installation Token for app ID {0}", this.getAppID());
                }
            }
            catch (Exception e) {
                if (this.cachedToken != null && !this.cachedToken.isExpired()) {
                    LOGGER.log(Level.WARNING, "Failed to generate new GitHub App Installation Token for app ID " + this.getAppID() + ": cached token is stale but has not expired", e);
                }
                throw e;
            }
            LOGGER.log(Level.FINEST, "Returned GitHub App Installation Token for app ID {0}", this.getAppID());
            return this.cachedToken;
        }
    }

    @NonNull
    public Secret getPassword() {
        return this.getToken(null).getToken();
    }

    @NonNull
    public String getUsername() {
        return this.getAppID();
    }

    public boolean isUsernameSecret() {
        return false;
    }

    @NonNull
    public GitHubAppCredentials contextualize(GitHubAppUsageContext context) {
        return this.cachedCredentials.computeIfAbsent(context, this::clone);
    }

    @NonNull
    private GitHubAppCredentials clone(GitHubAppUsageContext context) {
        GitHubAppCredentials clone = new GitHubAppCredentials(this.getScope(), this.getId(), this.getDescription(), this.getAppID(), this.getPrivateKey());
        clone.apiUri = this.getApiUri();
        clone.setRepositoryAccessStrategy(this.getRepositoryAccessStrategy());
        clone.setDefaultPermissionsStrategy(this.getDefaultPermissionsStrategy());
        clone.context = context;
        return clone;
    }

    @NonNull
    public Credentials forRun(Run<?, ?> context) {
        Job job = context.getParent();
        SCMSource src = SCMSource.SourceByItem.findSource((Item)job);
        if (src instanceof GitHubSCMSource) {
            GitHubSCMSource source = (GitHubSCMSource)src;
            GitHubAppUsageContext usageContext = GitHubAppUsageContext.builder().inferredOwner(source.getRepoOwner()).inferredRepository(source.getRepository()).permissions(this.getDefaultPermissionsStrategy().getPermissions()).build();
            return this.contextualize(usageContext);
        }
        GitHubRepositoryName ghrn = GitHubRepositoryName.create((GithubProjectProperty)((GithubProjectProperty)job.getProperty(GithubProjectProperty.class)));
        if (ghrn != null && (ALLOW_UNSAFE_REPOSITORY_INFERENCE || !(context instanceof FlowExecutionOwner.Executable))) {
            GitHubAppUsageContext usageContext = GitHubAppUsageContext.builder().inferredOwner(ghrn.userName).inferredRepository(ghrn.repositoryName).permissions(this.getDefaultPermissionsStrategy().getPermissions()).build();
            return this.contextualize(usageContext);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppInstallationToken getCachedToken() {
        GitHubAppCredentials gitHubAppCredentials = this;
        synchronized (gitHubAppCredentials) {
            return this.cachedToken;
        }
    }

    Object readResolve() {
        this.cachedCredentials = new ConcurrentHashMap<GitHubAppUsageContext, GitHubAppCredentials>();
        if (this.repositoryAccessStrategy == null) {
            this.setRepositoryAccessStrategy(new AccessSpecifiedRepositories(this.owner, List.of()));
            MigrationAdminMonitor.addMigratedCredentialId(this.getId());
        }
        if (this.defaultPermissionsStrategy == null) {
            this.setDefaultPermissionsStrategy(DefaultPermissionsStrategy.INHERIT_ALL);
        }
        this.owner = null;
        this.context = new GitHubAppUsageContext();
        return this;
    }

    protected Object writeReplace() {
        if (Channel.current() == null) {
            return this;
        }
        return new DelegatingGitHubAppCredentials(this);
    }

    private static class CredentialsTokenProvider
    extends TokenProvider {
        private final GitHubAppCredentials credentials;

        CredentialsTokenProvider(GitHubAppCredentials credentials) {
            super(credentials.getAppID(), credentials.getPrivateKey().getPlainText());
            this.credentials = credentials;
        }

        public String getEncodedAuthorization() throws IOException {
            Secret token = this.credentials.getToken(this.gitHub()).getToken();
            return String.format("token %s", token.getPlainText());
        }
    }

    private static abstract class TokenProvider
    extends GitHub.DependentAuthorizationProvider {
        protected TokenProvider(String appID, String privateKey) {
            super(GitHubAppCredentials.createJwtProvider(appID, privateKey));
        }

        static GitHub createTokenRefreshGitHub(String appId, String appPrivateKey, String apiUrl) throws IOException {
            TokenProvider provider = new TokenProvider(appId, appPrivateKey){

                public String getEncodedAuthorization() throws IOException {
                    return null;
                }
            };
            Connector.createGitHubBuilder(apiUrl).withAuthorizationProvider((AuthorizationProvider)provider).build();
            return provider.gitHub();
        }
    }

    static class AppInstallationToken
    implements Serializable {
        static long STALE_BEFORE_EXPIRATION_SECONDS = Long.getLong(GitHubAppCredentials.class.getName() + ".STALE_BEFORE_EXPIRATION_SECONDS", Duration.ofMinutes(45L).getSeconds());
        static final long STALE_AFTER_SECONDS = Duration.ofMinutes(30L).getSeconds();
        static long NOT_STALE_MINIMUM_SECONDS = Long.getLong(GitHubAppCredentials.class.getName() + ".NOT_STALE_MINIMUM_SECONDS", Duration.ofMinutes(1L).getSeconds());
        private final Secret token;
        private final long expirationEpochSeconds;
        private final long staleEpochSeconds;

        public AppInstallationToken(Secret token, long expirationEpochSeconds) {
            long now = Instant.now().getEpochSecond();
            long secondsUntilExpiration = expirationEpochSeconds - now;
            long minimumAllowedAge = Math.max(1L, NOT_STALE_MINIMUM_SECONDS);
            long maximumAllowedAge = Math.max(1L, 1L + STALE_AFTER_SECONDS);
            long secondsUntilStale = secondsUntilExpiration - STALE_BEFORE_EXPIRATION_SECONDS;
            if (secondsUntilStale < minimumAllowedAge) {
                secondsUntilStale = minimumAllowedAge;
            }
            if (secondsUntilStale > maximumAllowedAge) {
                secondsUntilStale = maximumAllowedAge;
            }
            LOGGER.log(Level.FINER, "Token will become stale after " + secondsUntilStale + " seconds");
            this.token = token;
            this.expirationEpochSeconds = expirationEpochSeconds;
            this.staleEpochSeconds = now + secondsUntilStale;
        }

        public Secret getToken() {
            return this.token;
        }

        public boolean isStale() {
            return Instant.now().getEpochSecond() >= this.staleEpochSeconds;
        }

        public boolean isExpired() {
            return Instant.now().getEpochSecond() >= this.expirationEpochSeconds;
        }

        long getTokenStaleEpochSeconds() {
            return this.staleEpochSeconds;
        }
    }

    private static class InferredAccessibleRepositoriesException
    extends IllegalStateException {
        public InferredAccessibleRepositoriesException(GitHubAppCredentials credentials) {
            super("Cannot generate App Installation Token for app ID " + credentials.getAppID() + " because the accessible repositories could not be inferred. This is due to the repository access configuration for the credentials with ID: " + credentials.getId());
        }
    }

    private static final class DelegatingGitHubAppCredentials
    extends BaseStandardCredentials
    implements StandardUsernamePasswordCredentials {
        private final String appID;
        private final String tokenRefreshData;
        private AppInstallationToken cachedToken;
        private transient Channel ch;

        DelegatingGitHubAppCredentials(GitHubAppCredentials onMaster) {
            super(onMaster.getScope(), onMaster.getId(), onMaster.getDescription());
            JenkinsJVM.checkJenkinsJVM();
            this.appID = onMaster.getAppID();
            JSONObject j = new JSONObject();
            j.put("appID", (Object)this.appID);
            j.put("privateKey", (Object)onMaster.getPrivateKey().getPlainText());
            j.put("apiUri", (Object)onMaster.actualApiUri());
            AccessibleRepositories accessibleRepositories = onMaster.getAccessibleRepositories();
            if (accessibleRepositories == null) {
                throw new InferredAccessibleRepositoriesException(onMaster);
            }
            j.put("owner", (Object)accessibleRepositories.getOwner());
            j.put("repositories", accessibleRepositories.getRepositories());
            j.put("permissions", onMaster.getPermissions());
            j.put("inferredOwner", (Object)onMaster.getContext().getInferredOwner());
            this.tokenRefreshData = Secret.fromString((String)j.toString()).getEncryptedValue();
            try {
                LOGGER.log(Level.FINEST, "Checking App Installation Token for app ID {0} before sending to agent", onMaster.getAppID());
                onMaster.getPassword();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to update stale GitHub App installation token for app ID " + onMaster.getAppID() + " before sending to agent", e);
            }
            this.cachedToken = onMaster.getCachedToken();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() {
            JenkinsJVM.checkNotJenkinsJVM();
            DelegatingGitHubAppCredentials delegatingGitHubAppCredentials = this;
            synchronized (delegatingGitHubAppCredentials) {
                this.ch = Channel.currentOrFail();
            }
            return this;
        }

        @NonNull
        public String getUsername() {
            return this.appID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Secret getPassword() {
            JenkinsJVM.checkNotJenkinsJVM();
            try {
                DelegatingGitHubAppCredentials delegatingGitHubAppCredentials = this;
                synchronized (delegatingGitHubAppCredentials) {
                    try {
                        if (this.cachedToken == null || this.cachedToken.isStale()) {
                            LOGGER.log(Level.FINE, "Generating App Installation Token for app ID {0} on agent", this.appID);
                            this.cachedToken = (AppInstallationToken)this.ch.call((Callable)new GetToken(this.tokenRefreshData));
                            LOGGER.log(Level.FINER, "Retrieved GitHub App Installation Token for app ID {0} on agent", this.appID);
                            LOGGER.log(Level.FINEST, () -> "Generated App Installation Token at " + Instant.now().toEpochMilli() + " on agent");
                        }
                    }
                    catch (Exception e) {
                        if (this.cachedToken != null && !this.cachedToken.isExpired()) {
                            LOGGER.log(Level.WARNING, "Failed to generate new GitHub App Installation Token for app ID " + this.appID + " on agent: cached token is stale but has not expired");
                            LOGGER.log(Level.FINER, () -> Functions.printThrowable((Throwable)e));
                        }
                        throw e;
                    }
                    LOGGER.log(Level.FINEST, "Returned GitHub App Installation Token for app ID {0} on agent", this.appID);
                    return this.cachedToken.getToken();
                }
            }
            catch (IOException | InterruptedException x) {
                throw new RuntimeException(x);
            }
        }

        private static final class GetToken
        extends SlaveToMasterCallable<AppInstallationToken, RuntimeException> {
            private final String data;

            GetToken(String data) {
                this.data = data;
            }

            public AppInstallationToken call() throws RuntimeException {
                JenkinsJVM.checkJenkinsJVM();
                JSONObject fields = JSONObject.fromObject((Object)Secret.fromString((String)this.data).getPlainText());
                LOGGER.log(Level.FINE, "Generating App Installation Token for app ID {0} for agent", fields.get("appID"));
                AppInstallationToken token = GitHubAppCredentials.generateAppInstallationToken(null, (String)fields.get("appID"), (String)fields.get("privateKey"), (String)fields.get("apiUri"), (String)fields.get("owner"), (List)fields.get("repositories"), (Map)fields.get("permissions"), (String)fields.get("inferredOwner"));
                LOGGER.log(Level.FINER, "Retrieved GitHub App Installation Token for app ID {0} for agent", fields.get("appID"));
                return token;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.GitHubAppCredentials_displayName();
        }

        public String getIconClassName() {
            return "symbol-logo-github plugin-ionicons-api";
        }

        public boolean isApiUriSelectable() {
            return !GitHubConfiguration.get().getEndpoints().isEmpty();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillApiUriItems() {
            return GitHubSCMNavigator.DescriptorImpl.getPossibleApiUriItems();
        }

        public static RepositoryAccessStrategy getDefaultRepositoryAccessStrategy() {
            return new AccessSpecifiedRepositories(null, List.of());
        }

        public FormValidation doCheckAppID(@QueryParameter String appID) {
            if (!appID.isEmpty()) {
                try {
                    Integer.parseInt(appID);
                }
                catch (NumberFormatException x) {
                    return FormValidation.warning((String)"An app ID is likely to be a number, distinct from the app name");
                }
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doTestConnection(@QueryParameter(value="appID") String appID, @QueryParameter(value="privateKey") String privateKey, @QueryParameter(value="apiUri") String apiUri, @QueryParameter(value="testConnectionOwner") String owner) {
            FormValidation formValidation;
            GitHub gitHubApp;
            List appInstallations;
            GitHubAppCredentials gitHubAppCredential = new GitHubAppCredentials(CredentialsScope.GLOBAL, "test-id-not-being-saved", null, appID, Secret.fromString((String)privateKey));
            gitHubAppCredential.setApiUri(apiUri);
            String inferredOwner = owner == null || owner.isEmpty() ? ((appInstallations = (gitHubApp = TokenProvider.createTokenRefreshGitHub(appID, privateKey, gitHubAppCredential.actualApiUri())).getApp().listInstallations().toList()).size() > 1 ? ((GHAppInstallation)appInstallations.get(0)).getAccount().getLogin() : "") : owner;
            GitHubAppUsageContext usageContext = GitHubAppUsageContext.builder().inferredOwner(inferredOwner).trust().build();
            GitHubAppCredentials contextualized = gitHubAppCredential.contextualize(usageContext);
            GitHub connect = Connector.connect(apiUri, (StandardCredentials)contextualized);
            try {
                formValidation = FormValidation.ok((String)("Success, Remaining rate limit: " + connect.getRateLimit().getRemaining()));
            }
            catch (Throwable throwable) {
                try {
                    Connector.release(connect);
                    throw throwable;
                }
                catch (Exception e) {
                    return FormValidation.error((Throwable)e, (String)String.format(GitHubAppCredentials.ERROR_AUTHENTICATING_GITHUB_APP, appID));
                }
            }
            Connector.release(connect);
            return formValidation;
        }
    }
}

