/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Run;
import jenkins.model.details.Detail;
import jenkins.model.details.DetailGroup;
import jenkins.scm.api.SCMDetailGroup;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

public class GitHubRepositoryDetail
extends Detail {
    public GitHubRepositoryDetail(Actionable object) {
        super(object);
    }

    @Nullable
    public String getIconClassName() {
        return "symbol-logo-github plugin-ionicons-api";
    }

    @Nullable
    public String getDisplayName() {
        GitHubSCMSource source = this.getSCMSource();
        if (source == null) {
            return null;
        }
        return source.getRepoOwner() + "/" + source.getRepository();
    }

    public String getLink() {
        GitHubSCMSource source = this.getSCMSource();
        if (source == null) {
            return null;
        }
        return source.getRepositoryUrl();
    }

    public DetailGroup getGroup() {
        return SCMDetailGroup.get();
    }

    private GitHubSCMSource getSCMSource() {
        SCMSource source = SCMSource.SourceByItem.findSource((Item)((Run)this.getObject()).getParent());
        if (source instanceof GitHubSCMSource) {
            GitHubSCMSource githubSource = (GitHubSCMSource)source;
            return githubSource;
        }
        return null;
    }
}

