/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHPermissionType;

@Restricted(value={NoExternalUse.class})
public class GitHubAppUsageContext {
    private String inferredOwner;
    private String inferredRepository;
    private Map<String, GHPermissionType> permissions = Collections.emptyMap();
    private boolean trusted;

    public static Builder builder() {
        return new Builder();
    }

    @CheckForNull
    public String getInferredOwner() {
        return this.inferredOwner;
    }

    @CheckForNull
    public String getInferredRepository() {
        return this.inferredRepository;
    }

    @CheckForNull
    public Map<String, GHPermissionType> getPermissions() {
        return this.permissions;
    }

    @CheckForNull
    public boolean isTrusted() {
        return this.trusted;
    }

    public int hashCode() {
        return Objects.hash(this.inferredOwner, this.inferredRepository, this.permissions, this.trusted);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GitHubAppUsageContext other = (GitHubAppUsageContext)obj;
        return Objects.equals(this.inferredOwner, other.inferredOwner) && Objects.equals(this.inferredRepository, other.inferredRepository) && Objects.equals(this.permissions, other.permissions) && this.trusted == other.trusted;
    }

    public static final class Builder {
        private final GitHubAppUsageContext result = new GitHubAppUsageContext();

        private Builder() {
        }

        public Builder inferredOwner(String inferredOwner) {
            this.result.inferredOwner = inferredOwner;
            return this;
        }

        public Builder inferredRepository(String inferredRepository) {
            this.result.inferredRepository = inferredRepository;
            return this;
        }

        public Builder permissions(Map<String, GHPermissionType> permissions) {
            this.result.permissions = permissions;
            return this;
        }

        public Builder trust() {
            this.result.trusted = true;
            return this;
        }

        public GitHubAppUsageContext build() {
            return this.result;
        }
    }
}

