/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source.app_credentials;

import hudson.Extension;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.GitHubAppUsageContext;
import org.jenkinsci.plugins.github_branch_source.app_credentials.AccessibleRepositories;
import org.jenkinsci.plugins.github_branch_source.app_credentials.Messages;
import org.jenkinsci.plugins.github_branch_source.app_credentials.RepositoryAccessStrategy;
import org.kohsuke.stapler.DataBoundConstructor;

public class AccessInferredRepository
extends RepositoryAccessStrategy {
    @DataBoundConstructor
    public AccessInferredRepository() {
    }

    @Override
    public AccessibleRepositories forContext(GitHubAppUsageContext context) {
        String inferredOwner = context.getInferredOwner();
        if (inferredOwner == null) {
            return null;
        }
        if (context.isTrusted()) {
            return new AccessibleRepositories(inferredOwner);
        }
        String inferredRepository = context.getInferredRepository();
        if (inferredRepository == null) {
            return null;
        }
        return new AccessibleRepositories(inferredOwner, inferredRepository);
    }

    @Symbol(value={"inferRepository"})
    @Extension
    public static class DescriptorImpl
    extends RepositoryAccessStrategy.RepositoryAccessStrategyDescriptor {
        public String getDisplayName() {
            return Messages.AccessInferredRepository_displayName();
        }
    }
}

