/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import hudson.model.Actionable;
import hudson.model.Run;
import jenkins.model.details.Detail;
import jenkins.model.details.DetailGroup;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMDetailGroup;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import org.jenkinsci.plugins.github_branch_source.GitHubLink;
import org.jenkinsci.plugins.github_branch_source.GitHubRepositoryDetail;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;

public class GitHubCommitDetail
extends Detail {
    public GitHubCommitDetail(Actionable object) {
        super(object);
    }

    public String getIconClassName() {
        return "symbol-git-commit-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        SCMRevision revision = this.getRevision();
        if (revision == null) {
            return null;
        }
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            AbstractGitSCMSource.SCMRevisionImpl abstractRevision = (AbstractGitSCMSource.SCMRevisionImpl)revision;
            return abstractRevision.getHash().substring(0, 7);
        }
        if (revision instanceof PullRequestSCMRevision) {
            PullRequestSCMRevision pullRequestSCMRevision = (PullRequestSCMRevision)revision;
            return pullRequestSCMRevision.getPullHash().substring(0, 7);
        }
        return null;
    }

    public String getLink() {
        SCMRevision revision = this.getRevision();
        if (revision == null) {
            return null;
        }
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            AbstractGitSCMSource.SCMRevisionImpl abstractRevision = (AbstractGitSCMSource.SCMRevisionImpl)revision;
            return new GitHubRepositoryDetail(this.getObject()).getLink() + "/commit/" + abstractRevision.getHash();
        }
        if (revision instanceof PullRequestSCMRevision) {
            PullRequestSCMRevision pullRequestSCMRevision = (PullRequestSCMRevision)revision;
            Run run = (Run)this.getObject();
            GitHubLink repoLink = (GitHubLink)run.getParent().getAction(GitHubLink.class);
            return repoLink.getUrl() + "/commits/" + pullRequestSCMRevision.getPullHash();
        }
        return null;
    }

    public DetailGroup getGroup() {
        return SCMDetailGroup.get();
    }

    private SCMRevision getRevision() {
        SCMRevisionAction scmRevisionAction = (SCMRevisionAction)this.getObject().getAction(SCMRevisionAction.class);
        if (scmRevisionAction == null) {
            return null;
        }
        return scmRevisionAction.getRevision();
    }
}

