/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source.app_credentials;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.GitHubAppUsageContext;
import org.jenkinsci.plugins.github_branch_source.app_credentials.AccessibleRepositories;
import org.jenkinsci.plugins.github_branch_source.app_credentials.Messages;
import org.jenkinsci.plugins.github_branch_source.app_credentials.RepositoryAccessStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AccessSpecifiedRepositories
extends RepositoryAccessStrategy {
    @CheckForNull
    private final String owner;
    @NonNull
    private final List<String> repositories;

    @DataBoundConstructor
    public AccessSpecifiedRepositories(@CheckForNull String owner, @NonNull List<String> repositories) {
        this.owner = Util.fixEmptyAndTrim((String)owner);
        this.repositories = new ArrayList<String>(repositories == null ? List.of() : repositories);
    }

    public String getOwner() {
        return this.owner;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    @Restricted(value={NoExternalUse.class})
    public String getRepositoriesForJelly() {
        return String.join((CharSequence)"\n", this.repositories);
    }

    @Override
    public AccessibleRepositories forContext(GitHubAppUsageContext context) {
        return new AccessibleRepositories(this.owner, this.repositories);
    }

    @Symbol(value={"specificRepositories"})
    @Extension
    public static class DescriptorImpl
    extends RepositoryAccessStrategy.RepositoryAccessStrategyDescriptor {
        public String getDisplayName() {
            return Messages.AccessSpecifiedRepositories_displayName();
        }

        public AccessSpecifiedRepositories newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String owner = formData.getString("owner");
            String repositoryField = formData.getString("repositories");
            List<String> repositories = DescriptorImpl.parseRepositories(repositoryField);
            return new AccessSpecifiedRepositories(owner, repositories);
        }

        public FormValidation doCheckRepositories(@QueryParameter String repositories) {
            if (DescriptorImpl.parseRepositories(repositories).isEmpty()) {
                return FormValidation.warning((String)Messages.AccessSpecifiedRepositories_noRespositories());
            }
            return FormValidation.ok();
        }

        private static List<String> parseRepositories(String repositoryField) {
            if ((repositoryField = Util.fixEmptyAndTrim((String)repositoryField)) == null) {
                return Collections.emptyList();
            }
            return Stream.of(repositoryField.split("\r?\n")).map(Util::fixEmptyAndTrim).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

