/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.trait.SCMSourceBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

public class GitHubSCMSourceBuilder
extends SCMSourceBuilder<GitHubSCMSourceBuilder, GitHubSCMSource> {
    @CheckForNull
    private final String id;
    @CheckForNull
    private final String apiUri;
    @CheckForNull
    private final String credentialsId;
    @NonNull
    private final String repoOwner;
    @CheckForNull
    private StandardCredentials credentials;

    public GitHubSCMSourceBuilder(@CheckForNull String id, @CheckForNull String apiUri, @CheckForNull String credentialsId, @NonNull String repoOwner, @NonNull String repoName) {
        super(GitHubSCMSource.class, repoName);
        this.id = id;
        this.apiUri = apiUri;
        this.repoOwner = repoOwner;
        this.credentialsId = credentialsId;
    }

    public final String id() {
        return this.id;
    }

    @CheckForNull
    public final String apiUri() {
        return this.apiUri;
    }

    @CheckForNull
    public final String credentialsId() {
        return this.credentials == null ? this.credentialsId : this.credentials.getId();
    }

    @NonNull
    public final String repoOwner() {
        return this.repoOwner;
    }

    @NonNull
    SCMSourceBuilder<GitHubSCMSourceBuilder, GitHubSCMSource> withCredentials(StandardCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @NonNull
    public GitHubSCMSource build() {
        GitHubSCMSource result = new GitHubSCMSource(this.repoOwner, this.projectName(), this.credentials);
        result.setId(this.id());
        result.setApiUri(this.apiUri());
        result.setCredentialsId(this.credentialsId());
        result.setTraits(this.traits());
        return result;
    }
}

