/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.io.FileBoolean;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

public class GitHubOrgWebHook {
    private static final Logger LOGGER = Logger.getLogger(GitHubOrgWebHook.class.getName());
    private static final List<GHEvent> EVENTS = Arrays.asList(GHEvent.REPOSITORY, GHEvent.PUSH, GHEvent.PULL_REQUEST, GHEvent.PULL_REQUEST_REVIEW_COMMENT);

    public static void register(GitHub hub, String orgName) throws IOException {
        String rootUrl = System.getProperty("jenkins.hook.url");
        if (rootUrl == null) {
            rootUrl = Jenkins.get().getRootUrl();
        }
        if (rootUrl == null) {
            return;
        }
        GHUser u = hub.getUser(orgName);
        FileBoolean orghook = new FileBoolean(GitHubOrgWebHook.getTrackingFile(orgName));
        if (orghook.isOff()) {
            try {
                GHOrganization org = hub.getOrganization(orgName);
                String url = rootUrl + "github-webhook/";
                boolean found = false;
                for (GHHook hook : org.getHooks()) {
                    if (!((String)hook.getConfig().get("url")).equals(url)) continue;
                    found = !hook.getEvents().containsAll(EVENTS);
                    break;
                }
                if (!found) {
                    org.createWebHook(new URL(url), EVENTS);
                    LOGGER.log(Level.INFO, "A webhook was registered for the organization {0}", org.getHtmlUrl());
                }
                orghook.on();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to {0} (missing permissions?): {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                LOGGER.log(Level.FINE, null, e);
            }
            catch (RateLimitExceededException e) {
                LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to {0}: {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                LOGGER.log(Level.FINE, null, e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to " + String.valueOf(u.getHtmlUrl()), e);
            }
        }
    }

    private static File getTrackingFile(String orgName) {
        return new File(Jenkins.get().getRootDir(), "github-webhooks/GitHubOrgHook." + orgName);
    }

    public static void deregister(GitHub hub, String orgName) throws IOException {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl == null) {
            return;
        }
        GHUser u = hub.getUser(orgName);
        FileBoolean orghook = new FileBoolean(GitHubOrgWebHook.getTrackingFile(orgName));
        if (orghook.isOn()) {
            try {
                GHOrganization org = hub.getOrganization(orgName);
                String url = rootUrl + "github-webhook/";
                for (GHHook hook : org.getHooks()) {
                    if (!((String)hook.getConfig().get("url")).equals(url)) continue;
                    hook.delete();
                    LOGGER.log(Level.INFO, "A webhook was deregistered for the organization {0}", org.getHtmlUrl());
                }
                orghook.off();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to deregister GitHub Org hook to {0} (missing permissions?): {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                LOGGER.log(Level.FINE, null, e);
            }
            catch (RateLimitExceededException e) {
                LOGGER.log(Level.WARNING, "Failed to deregister GitHub Org hook to {0}: {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                LOGGER.log(Level.FINE, null, e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to deregister GitHub Org hook to " + String.valueOf(u.getHtmlUrl()), e);
            }
        }
    }
}

