/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source.app_credentials;

import java.util.Collections;
import java.util.Map;
import org.jenkinsci.plugins.github_branch_source.app_credentials.Messages;
import org.kohsuke.github.GHPermissionType;

public enum DefaultPermissionsStrategy {
    CONTENTS_READ(Collections.singletonMap("contents", GHPermissionType.READ)),
    CONTENTS_WRITE(Collections.singletonMap("contents", GHPermissionType.WRITE)),
    INHERIT_ALL(Collections.emptyMap());

    private final Map<String, GHPermissionType> permissions;

    private DefaultPermissionsStrategy(Map<String, GHPermissionType> permissions) {
        this.permissions = permissions;
    }

    public Map<String, GHPermissionType> getPermissions() {
        return this.permissions;
    }

    public String getDisplayName() {
        switch (this) {
            case CONTENTS_READ: {
                return Messages.DefaultPermissionsStrategy_contentsRead();
            }
            case CONTENTS_WRITE: {
                return Messages.DefaultPermissionsStrategy_contentsWrite();
            }
            case INHERIT_ALL: {
                return Messages.DefaultPermissionsStrategy_inheritAll();
            }
        }
        throw new AssertionError((Object)("Unsupported enum variant " + String.valueOf((Object)this)));
    }
}

