/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.handler;

import com.gitee.jenkins.cause.CauseData;
import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.gitee.hook.model.WebHook;
import com.gitee.jenkins.trigger.exception.NoRevisionToBuildException;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BuildInstructionFilter;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilter;
import com.gitee.jenkins.trigger.handler.PendingBuildsHandler;
import com.gitee.jenkins.trigger.handler.WebHookTriggerHandler;
import com.gitee.jenkins.util.LoggerUtil;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import hudson.scm.SCM;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public abstract class AbstractWebHookTriggerHandler<H extends WebHook>
implements WebHookTriggerHandler<H> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWebHookTriggerHandler.class.getName());
    protected PendingBuildsHandler pendingBuildsHandler = new PendingBuildsHandler();

    @Override
    public void handle(Job<?, ?> job, H hook, BuildInstructionFilter buildInstructionFilter, boolean skipLastCommitHasBeenBuild, BranchFilter branchFilter, PullRequestLabelFilter pullRequestLabelFilter) {
        if (this.isCiSkip(hook, buildInstructionFilter)) {
            LOGGER.log(Level.INFO, "Skipping due to ci-skip.");
            return;
        }
        if (skipLastCommitHasBeenBuild && this.isCommitSkip(job, hook)) {
            LOGGER.log(Level.INFO, "Skipping due to ignore last commit has been build.");
            return;
        }
        String targetBranch = this.getTargetBranch(hook);
        if (branchFilter.isBranchAllowed(targetBranch)) {
            LOGGER.log(Level.INFO, "{0} triggered for {1}.", LoggerUtil.toArray(job.getFullName(), this.getTriggerType()));
            this.cancelPendingBuildsIfNecessary(job, hook);
            this.cancelIncompleteBuildIfNecessary(job, hook);
            this.scheduleBuild(job, this.createActions(job, hook));
        } else {
            LOGGER.log(Level.INFO, "branch {0} is not allowed", targetBranch);
        }
    }

    protected abstract String getTriggerType();

    protected abstract boolean isCiSkip(H var1, BuildInstructionFilter var2);

    protected abstract boolean isCommitSkip(Job<?, ?> var1, H var2);

    protected Action[] createActions(Job<?, ?> job, H hook) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new CauseAction((Cause)new GiteeWebHookCause(this.retrieveCauseData(hook))));
        try {
            SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
            GitSCM gitSCM = this.getGitSCM(item);
            actions.add(this.createRevisionParameter(hook, gitSCM));
        }
        catch (NoRevisionToBuildException e) {
            LOGGER.log(Level.WARNING, "unknown handled situation, dont know what revision to build for req {0} for job {1}", new Object[]{hook, job != null ? job.getFullName() : null});
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected void cancelPendingBuildsIfNecessary(Job<?, ?> job, H hook) {
    }

    protected void cancelIncompleteBuildIfNecessary(Job<?, ?> job, H hook) {
    }

    protected abstract CauseData retrieveCauseData(H var1);

    protected abstract String getTargetBranch(H var1);

    protected abstract RevisionParameterAction createRevisionParameter(H var1, GitSCM var2) throws NoRevisionToBuildException;

    protected abstract BuildStatusUpdate retrieveBuildStatusUpdate(H var1);

    protected URIish retrieveUrIish(WebHook hook) {
        try {
            if (hook.getRepository() != null) {
                return new URIish(hook.getRepository().getUrl());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "could not parse URL");
        }
        return null;
    }

    protected void scheduleBuild(Job<?, ?> job, Action[] actions) {
        ParameterizedJobMixIn.ParameterizedJob abstractProject;
        int projectBuildDelay = 0;
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob && (abstractProject = (ParameterizedJobMixIn.ParameterizedJob)job).getQuietPeriod() > projectBuildDelay) {
            projectBuildDelay = abstractProject.getQuietPeriod();
        }
        this.retrieveScheduleJob(job).scheduleBuild2(projectBuildDelay, actions);
    }

    private ParameterizedJobMixIn retrieveScheduleJob(final Job<?, ?> job) {
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
    }

    private GitSCM getGitSCM(SCMTriggerItem item) {
        if (item != null) {
            for (SCM scm : item.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                GitSCM gitSCM = (GitSCM)scm;
                return gitSCM;
            }
        }
        return null;
    }

    protected void doStop(Run<?, ?> build) throws IOException, ServletException {
        if (build.isBuilding()) {
            if (build instanceof AbstractBuild) {
                AbstractBuild abstractBuild = (AbstractBuild)build;
                abstractBuild.doStop();
                LOGGER.log(Level.WARNING, "Abort incomplete build");
            } else if (build instanceof WorkflowRun) {
                WorkflowRun workflowRun = (WorkflowRun)build;
                workflowRun.doStop();
                LOGGER.log(Level.WARNING, "Abort incomplete build");
            } else {
                LOGGER.log(Level.WARNING, "Unable to abort incomplete build, build type not found: " + build.getClass().getName());
            }
        }
    }

    public static class BuildStatusUpdate {
        private final Integer projectId;
        private final String sha;
        private final String ref;

        @GeneratePojoBuilder(intoPackage="*.builder.generated", withFactoryMethod="*")
        public BuildStatusUpdate(Integer projectId, String sha, String ref) {
            this.projectId = projectId;
            this.sha = sha;
            this.ref = ref;
        }

        public Integer getProjectId() {
            return this.projectId;
        }

        public String getSha() {
            return this.sha;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

