/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.filter;

import com.gitee.jenkins.trigger.filter.BuildInstructionFilter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuildInstructionFilterType implements BuildInstructionFilter
{
    NONE(""){

        @Override
        public boolean isBuildAllow(String body) {
            return true;
        }
    }
    ,
    CI_SKIP("[ci-skip]"){

        @Override
        public boolean isBuildAllow(String body) {
            return body == null || !body.contains(this.getBody());
        }
    }
    ,
    CI_BUILD("[ci-build]"){

        @Override
        public boolean isBuildAllow(String body) {
            return body != null && body.contains(this.getBody());
        }
    };

    private final String body;

    private BuildInstructionFilterType(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }
}

