/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.api.impl;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.gitee.jenkins.gitee.JacksonConfig;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.GiteeClientBuilder;
import com.gitee.jenkins.gitee.api.impl.GiteeApiProxy;
import com.gitee.jenkins.gitee.api.impl.ResteasyGiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.util.JsonUtil;
import com.gitee.jenkins.util.LoggerUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ProxyConfiguration;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.JaxrsFormProvider;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataWriter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResteasyGiteeClientBuilder
extends GiteeClientBuilder {
    private static final Logger LOGGER = Logger.getLogger(ResteasyGiteeClientBuilder.class.getName());
    private static final String PRIVATE_TOKEN = "PRIVATE-TOKEN";
    private final Class<? extends GiteeApiProxy> apiProxyClass;
    private final Function<PullRequest, Integer> pullRequestIdProvider;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void setRuntimeDelegate() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new ResteasyProviderFactoryImpl());
    }

    ResteasyGiteeClientBuilder(String id, int ordinal, Class<? extends GiteeApiProxy> apiProxyClass, Function<PullRequest, Integer> pullRequestIdProvider) {
        super(id, ordinal);
        this.apiProxyClass = apiProxyClass;
        this.pullRequestIdProvider = pullRequestIdProvider;
    }

    @Override
    @NonNull
    public final GiteeClient buildClient(String url, String apiToken, boolean ignoreCertificateErrors, int connectionTimeout, int readTimeout) {
        return this.buildClient(url, apiToken, Jenkins.get().proxy, ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    private GiteeClient buildClient(String url, String apiToken, ProxyConfiguration httpProxyConfig, boolean ignoreCertificateErrors, int connectionTimeout, int readTimeout) {
        Proxy proxy;
        HttpCredsResteasyClientBuilderImpl builder = new HttpCredsResteasyClientBuilderImpl();
        if (ignoreCertificateErrors) {
            builder.hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY);
            builder.disableTrustManager();
        }
        if (httpProxyConfig != null && (proxy = httpProxyConfig.createProxy(this.getHost(url))).type() == Proxy.Type.HTTP) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            builder.defaultProxy(address.getHostString().replaceFirst("^.*://", ""), address.getPort(), address.getHostName().startsWith("https") ? "https" : "http", httpProxyConfig.getUserName(), httpProxyConfig.getSecretPassword().getPlainText());
        }
        ResteasyWebTarget target = builder.connectionPoolSize(60).maxPooledPerRoute(30).connectTimeout((long)connectionTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).register((Object)new JacksonJsonProvider()).register((Object)new JacksonConfig()).register((Object)new ApiHeaderTokenFilter(apiToken)).register((Object)new LoggingFilter()).register((Object)new RemoveAcceptEncodingFilter()).register((Object)new JaxrsFormProvider()).register(MultipartFormDataWriter.class).register(InputStreamProvider.class).build().target(url);
        GiteeApiProxy apiProxy = (GiteeApiProxy)new ProxyBuilderImpl(this.apiProxyClass, (WebTarget)target).classloader(this.apiProxyClass.getClassLoader()).build();
        return new ResteasyGiteeClient(url, apiProxy, this.pullRequestIdProvider);
    }

    private String getHost(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static class HttpCredsResteasyClientBuilderImpl
    extends ResteasyClientBuilderImpl {
        private CredentialsProvider proxyCredentials;

        private HttpCredsResteasyClientBuilderImpl() {
        }

        HttpCredsResteasyClientBuilderImpl defaultProxy(String hostname, int port, String scheme, String username, String password) {
            super.defaultProxy(hostname, port, scheme);
            if (username != null && password != null) {
                this.proxyCredentials = new BasicCredentialsProvider();
                this.proxyCredentials.setCredentials(new AuthScope(hostname, port), (Credentials)new UsernamePasswordCredentials(username, password));
            }
            return this;
        }
    }

    @Priority(value=3000)
    private static class ApiHeaderTokenFilter
    implements ClientRequestFilter {
        private final String giteeApiToken;

        ApiHeaderTokenFilter(String giteeApiToken) {
            this.giteeApiToken = giteeApiToken;
        }

        public void filter(ClientRequestContext requestContext) {
            requestContext.getHeaders().putSingle((Object)ResteasyGiteeClientBuilder.PRIVATE_TOKEN, (Object)this.giteeApiToken);
        }
    }

    @Priority(value=5000)
    private static class LoggingFilter
    implements ClientRequestFilter,
    ClientResponseFilter {
        private LoggingFilter() {
        }

        public void filter(ClientRequestContext context) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Call Gitee:\nHTTP method: {0}\nURL: {1}\nRequest headers: [\n{2}\n]", LoggerUtil.toArray(context.getMethod(), context.getUri(), this.toFilteredString((MultivaluedMap<String, Object>)context.getHeaders())));
            }
        }

        public void filter(ClientRequestContext request, ClientResponseContext response) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Got response from Gitee:\nURL: {0}\nStatus: {1} {2}\nResponse headers: [\n{3}\n]\nResponse body: {4}", LoggerUtil.toArray(request.getUri(), response.getStatus(), response.getStatusInfo(), this.toString((MultivaluedMap<String, String>)response.getHeaders()), this.getPrettyPrintResponseBody(response)));
            }
        }

        private String toFilteredString(MultivaluedMap<String, Object> headers) {
            return FluentIterable.from((Iterable)headers.entrySet()).transform((Function)new HeaderToFilteredString()).join(Joiner.on((String)",\n"));
        }

        private String toString(MultivaluedMap<String, String> headers) {
            return FluentIterable.from((Iterable)headers.entrySet()).transform((Function)new HeaderToString()).join(Joiner.on((String)",\n"));
        }

        private String getPrettyPrintResponseBody(ClientResponseContext responseContext) {
            String responseBody = this.getResponseBody(responseContext);
            if (StringUtils.isNotEmpty((String)responseBody) && responseContext.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                return JsonUtil.toPrettyPrint(responseBody);
            }
            return responseBody;
        }

        private String getResponseBody(ClientResponseContext context) {
            String string;
            block8: {
                InputStream entityStream = context.getEntityStream();
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)entityStream);
                    context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
                    string = new String(bytes);
                    if (entityStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (entityStream != null) {
                            try {
                                entityStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Failure during reading the response body", e);
                        context.setEntityStream((InputStream)new ByteArrayInputStream(new byte[0]));
                        return "";
                    }
                }
                entityStream.close();
            }
            return string;
        }

        private static class HeaderToFilteredString
        implements Function<Map.Entry<String, List<Object>>, String> {
            private HeaderToFilteredString() {
            }

            @Nullable
            public String apply(@Nullable Map.Entry<String, List<Object>> input) {
                if (input == null) {
                    return null;
                }
                if (input.getKey().equals(ResteasyGiteeClientBuilder.PRIVATE_TOKEN)) {
                    return input.getKey() + " = [****FILTERED****]";
                }
                return input.getKey() + " = [" + Joiner.on((String)", ").join((Iterable)input.getValue()) + "]";
            }
        }

        private static class HeaderToString
        implements Function<Map.Entry<String, List<String>>, String> {
            private HeaderToString() {
            }

            @Nullable
            public String apply(@Nullable Map.Entry<String, List<String>> input) {
                return input == null ? null : input.getKey() + " = [" + Joiner.on((String)", ").join((Iterable)input.getValue()) + "]";
            }
        }
    }

    @Priority(value=3000)
    private static class RemoveAcceptEncodingFilter
    implements ClientRequestFilter {
        RemoveAcceptEncodingFilter() {
        }

        public void filter(ClientRequestContext clientRequestContext) {
            clientRequestContext.getHeaders().remove((Object)"Accept-Encoding");
        }
    }
}

